package com.dla.dda.bussines.test;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.Assert;
import org.testng.annotations.Test;

import com.dla.dda.bussines.ContratoBussines;
import com.dla.dda.domain.contrato.BonoFees;
import com.dla.dda.domain.contrato.ContratoDDA;
import com.dla.dda.domain.contrato.FeesDDA;
import com.dla.dda.domain.contrato.FeesFlat;
import com.dla.dda.domain.contrato.PeriodoFlat;
import com.dla.dda.domain.contrato.Rango;
import com.dla.dda.domain.contrato.TituloDDA;
import com.dla.dda.domain.exceptions.DLAIntegrationException;
import com.dla.dda.persistence.model.DdaTContrato;
import com.dla.dda.persistence.model.DdaTContratoPago;
import com.dla.dda.services.ContratoService;

/**
 * @see Prueba unitaria para los contratos
 * @author montieln
 *
 */
public class ContratosTest extends BaseTest {

	private static Logger logger = LoggerFactory.getLogger(ContratosTest.class);

	@Autowired
	private ContratoBussines servicio;

	@Autowired
	private ContratoService repository;

	@Test(enabled = false)
	public void findDetalleContratoSuscriptorTest() throws DLAIntegrationException {

		Long idContratoSuscripcion = 19L;
		ContratoDDA detalle = servicio.getContratoDetalle(idContratoSuscripcion);

		logger.info(" detalle [{}] suscripcion [{}] ", detalle, detalle.getFeesDDA().getSuscriptor());

	}

	@Test(enabled = false)
	public void findDetalleContratoFlatTest() throws DLAIntegrationException {

		Long idContrato = 2L;
		ContratoDDA detalle = servicio.getContratoDetalle(idContrato);
		logger.info(" detalle [{}] suscripcion [{}] bono [{}] ", detalle, detalle.getFeesDDA().getFlat().getPeriodos(),
				detalle.getFeesDDA().getBono().getRangos().size());

	}

	@Test(enabled = false)
	public void findPeriodosFlatFeesTest() throws DLAIntegrationException {

		Long idContratoPago = 289L;

		Map<String, List<PeriodoFlat>> periodos = repository.findPeriodosFlatFees(idContratoPago);

		Set<String> keys = periodos.keySet();

		logger.info(" [{}]", periodos.size());

		for (String key : keys) {

			List<PeriodoFlat> entity = periodos.get(key);
			showDataFlat(entity);

		}

	}

	@Test(enabled = false)
	public void findFlatFeesTest() throws DLAIntegrationException {

		Long idContrato = 21L;
		List<DdaTContratoPago> fees = repository.findFeesByContratos(idContrato);
		DdaTContrato ddaTContrato = repository.getContrato(idContrato);

		FeesDDA feesDDA = servicio.getFees(ddaTContrato, fees);

		// Imprimimos los FEES
		FeesFlat flatFees = feesDDA.getFlat();
		Map<String, List<PeriodoFlat>> peridosFlat = flatFees.getPeriodos();

		// logger.info("flatFees: " + flatFees);
		// logger.info("peridosFlat: " + peridosFlat);

		BonoFees bono = feesDDA.getBono();

		showDataFlat(peridosFlat);
		showData(bono);

	}

	@Test(enabled = true)
	public void findContratosEstudioTest() throws DLAIntegrationException {

		int idEstudio = 2;

		List<ContratoDDA> contratos = servicio.getContratosXEstudio(idEstudio);

		logger.info("Total [{}]", contratos.size());

		for (ContratoDDA contrato : contratos) {
			logger.info("Contrato [{}] ", contrato);

		}

	}

	@Test(enabled = false)
	public void findFeesByContrato() throws DLAIntegrationException {

		Long idContratoSuscripcion = 22L;
		List<DdaTContratoPago> feesSuscripcion = repository.findFeesByContratos(idContratoSuscripcion);
		logger.info("Suscripcion [{}]", feesSuscripcion.size());
		showData(feesSuscripcion);

		Long idContratoFlat = 24L;
		List<DdaTContratoPago> feesFlat = repository.findFeesByContratos(idContratoFlat);
		logger.info("Flat [{}]", feesFlat.size());
		showData(feesFlat);

	}

	@Test(enabled = false)
	public void findSuscripcionTest() throws DLAIntegrationException {
		// suscripcion = 285, 286
		// FLat = 289
		Long idContratoPago = 285L;
		Map<String, List<Rango>> fees = repository.findPeriodosSuscripcionFees(idContratoPago);

		logger.info(" fees suscripcion [{}]", fees.size());
		showData(fees);

	}

	@Test(enabled = false)
	public void findSuscripcionFeesTest() throws DLAIntegrationException {

		Long idContrato = 3L;
		Map<String, List<Rango>> periodos = repository.findPeriodosSuscripcionFees(idContrato);

		logger.info(" fees suscripcion [{}]", periodos);

		

	}

	@Test(enabled = false)
	public void findTitulosByContratoTest() throws DLAIntegrationException {
		Long idContrato = 2L;
		List<TituloDDA> titulos = repository.findTitulos(idContrato);

		logger.info("total titulos [{}]", titulos.size());

		for (TituloDDA titulo : titulos) {
			logger.info(" titulo [{}]", titulo);
		}

	}

	private void showData(List<DdaTContratoPago> data) {

		for (DdaTContratoPago entity : data) {
			logger.info(" contratoPago [{}] inicio [{}] fin [{}] tipo [{}]", entity.getIdContratoPago(),
					entity.getFechaInicio(), entity.getFechaFin(), entity.getTipoPago());
		}

	}

	private void showData(Map<String, List<Rango>> fees) {

		for (String key : fees.keySet()) {

			List<Rango> rangos = fees.get(key);
			logger.info(" cat [{}] rangos [{}]", key, rangos);

		}

	}

	private void showDataFlat(List<PeriodoFlat> periodos) {

		for (PeriodoFlat periodo : periodos) {
			logger.info(" [{}] ", periodo);
		}

	}

	private void showDataFlat(Map<String, List<PeriodoFlat>> peridosFlat) {

		logger.info("show periodos flat");

		Set<String> keys = peridosFlat.keySet();

		for (String key : keys) {

			logger.info("Categoria [{}]", key);
			List<PeriodoFlat> periodos = peridosFlat.get(key);
			showDataFlat(periodos);
		}

	}

	private void showData(BonoFees bono) {

		logger.info("Show bono fees");


		Map<String, List<Rango>> rangos = bono.getRangos();

		showData(rangos);

	}

}
