package com.dla.dda.bussines.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.testng.annotations.Test;

import com.dla.dda.bussines.EmailBussines;
import com.dla.dda.domain.constants.Operacion;
import com.dla.dda.domain.exceptions.DLAIntegrationException;
import com.dla.dda.domain.model.request.EmailRequest;
import com.dla.dda.domain.model.response.EmailResponse;
import com.dla.dda.services.SeguimientoEmailService;

/**
 * @see Prueba unitaria para envio de correos
 * @author montieln
 *
 */
public class EmailBussinesTest extends BaseTest {

	@Autowired
	private EmailBussines service;

	final private static Logger logger = LoggerFactory.getLogger(EmailBussinesTest.class);
	
	@Autowired
	private SeguimientoEmailService seguimientoEmailService;
	
	@Test(enabled = false)
	public void sendEmailTest() {

		//String[] destinatarios = new String[] { "oruiz@amcocloud.onmicrosoft.com", "olveras@globalhitss.com", "jcazares@amco.mx", "jbarany@dlatv.net", "smorales@amco.mx", "cjara@dlatv.net", "avm@amco.mx", "rrosales@dlatv.net", "vorozco@amco.mx", "cfranco@amco.mx", "abocanegra@amco.mx", "jmejia@dlatv.net" };
		String[] destinatarios = new String[] { "amadorcpmx@hotmail.com" };

		EmailRequest request = new EmailRequest();
		request.setBody("{\"lineaFinal\":\"Para revisar haga \",\"numeroContrato\":\"UNST00299O\"}");
		request.setDate("Thu Aug 31 20:00:00 CDT 2017");
		request.setDestinatarios(destinatarios);
		request.setName("administrador");
		request.setSubject("DDA - Seguimiento de contrato: UNST00299O");
		request.setToCompany("Derechos de Autor");
		request.setUserName("cuevasla@globalhitss.com");
		request.setOperacion(Operacion.RECORDATORIO);
		request.setAttachmentFilename(null);
		request.setContentType(null);
		request.setEtiqueta("Se le informa que el responsable del &aacute;rea: Adquisiciones, <b>no ha realizado</b> la <br/> autorizaci&oacute;n asociada al contrato: <b>UNST00299O</b>.");
		
/*		[EmailRequest [
		         destinatarios=[oruiz@amcocloud.onmicrosoft.com, olveras@globalhitss.com, jcazares@amco.mx, jbarany@dlatv.net, smorales@amco.mx, cjara@dlatv.net, avm@amco.mx, rrosales@dlatv.net, vorozco@amco.mx, cfranco@amco.mx, abocanegra@amco.mx, jmejia@dlatv.net], 
		         body={"lineaFinal":"Para revisar haga ","numeroContrato":"UNST00299O"}, 
		         name=administrador, 
		         date=Thu Aug 31 20:00:00 CDT 2017, 
		         userName=administrador@dladda.com, 
		         toCompany=Derechos de Autor, 
		         subject=DDA - Seguimiento de contrato: UNST00299O, 
		         operacion=RECORDATORIO, 
		         etiqueta=Se le informa que el responsable del &aacute;rea: Adquisiciones, <b>no ha realizado</b> la <br/> autorizaci&oacute;n asociada al contrato: <b>UNST00299O</b>.
		         ]*/

		logger.info("Request [{}]", request);
		
/*		MessageAttachment [
		    toAddres=[oruiz@amcocloud.onmicrosoft.com, olveras@globalhitss.com, jcazares@amco.mx, jbarany@dlatv.net, smorales@amco.mx, cjara@dlatv.net, avm@amco.mx, rrosales@dlatv.net, vorozco@amco.mx, cfranco@amco.mx, abocanegra@amco.mx, jmejia@dlatv.net], 
		    fromAdddres=administrador@dladda.com, 
		    contentType=null, 
		    attachmentFilename=null, 
		    texto=null, 
		    subject=DDA - Seguimiento de contrato: UNST00299O]*/

		EmailResponse response = service.enviaCorreo(request);

		logger.info("Response [{}]", response);

	}

	@Test(enabled = false)
	public void sendEmailPDFTest() throws IOException {

		EmailRequest request = new EmailRequest();

		InputStream initialStream = new FileInputStream(new File("C:\\Users\\bark\\Desktop\\atlas_best_practices.pdf"));
		byte[] targetArray = new byte[initialStream.available()];
		initialStream.read(targetArray);

		request.setAttachmentFilename("2.pdf");
		request.setContentType("application/pdf");
		InputStreamSource attachmentSource = new ByteArrayResource(targetArray);
		request.setIos(attachmentSource);

		String[] destinatarios = new String[] { "bartolof@globalhitss.com" };

		request.setOperacion(Operacion.PRESUPUESTOS);
		request.setBody("Es el cuerpo del correo");
		request.setDate("18-feb-2016");
		request.setDestinatarios(destinatarios);
		request.setName("Noe Maxihelleen Montiel Hernandez");
		request.setSubject("Correo Prueba");
		request.setToCompany("GlobalHitss");
		request.setUserName(""); // agregar el correo de donde se va enviar!!

		logger.info("Request [{}]", request);

		EmailResponse response = service.enviaCorreo(request);

		logger.info("Response [{}]", response);

		initialStream.close();

	}
	
	@Test(enabled = false)
	public void pruebaTemporal() throws IOException, DLAIntegrationException {
		logger.info("Respuesta : [{}]", seguimientoEmailService.seguimientoDeCorreosPendientes());
	}
	
	

}
