/*
 * Decompiled with CFR 0.152.
 */
package com.dla.dda.services;

import com.dla.dda.domain.constants.ErrorCodes;
import com.dla.dda.domain.exceptions.DLAIntegrationException;
import com.dla.dda.domain.exceptions.utils.ErrorUtils;
import com.dla.dda.persistence.dao.BaseDAO;
import com.dla.dda.persistence.model.DdaCArea;
import com.dla.dda.persistence.model.DlaCEmpresa;
import com.dla.dda.persistence.model.DlaCUsuario;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class UsuariosService {
    @Autowired
    private BaseDAO dao;
    private static Logger logger = LoggerFactory.getLogger(UsuariosService.class);

    public List<DlaCUsuario> findUsuarios() throws DLAIntegrationException {
        List response = null;
        try {
            response = this.dao.findListByQuery("findUsuarios", DlaCUsuario.class);
        }
        catch (Exception e) {
            logger.error("Error to findUsuarios [{}]", (Object)e.getMessage(), (Object)e);
            ErrorCodes error = ErrorCodes.INFRASTRUCTURE;
            ErrorUtils.setMessage((ErrorCodes)error, (String)e.getMessage());
            throw new DLAIntegrationException(error);
        }
        return response;
    }

    public DdaCArea findAreaById(Long idArea) throws DLAIntegrationException {
        DdaCArea area = null;
        try {
            if (idArea != null) {
                area = (DdaCArea)this.dao.read((Serializable)Byte.valueOf(idArea.byteValue()), DdaCArea.class);
            }
        }
        catch (Exception e) {
            logger.error("Error to get contrato [{}] [{}]", new Object[]{idArea, e.getMessage(), e});
            ErrorCodes error = ErrorCodes.INFRASTRUCTURE;
            ErrorUtils.setMessage((ErrorCodes)error, (String)e.getMessage());
            throw new DLAIntegrationException(error);
        }
        return area;
    }

    public DlaCEmpresa findEmpresaById(Long idEmpresa) throws DLAIntegrationException {
        DlaCEmpresa empresa = null;
        try {
            if (idEmpresa != null) {
                empresa = (DlaCEmpresa)this.dao.read((Serializable)Integer.valueOf(idEmpresa.intValue()), DlaCEmpresa.class);
            }
        }
        catch (Exception e) {
            logger.error("Error to get contrato [{}] [{}]", new Object[]{idEmpresa, e.getMessage(), e});
            ErrorCodes error = ErrorCodes.INFRASTRUCTURE;
            ErrorUtils.setMessage((ErrorCodes)error, (String)e.getMessage());
            throw new DLAIntegrationException(error);
        }
        return empresa;
    }
}

