/*
 * Decompiled with CFR 0.152.
 */
package com.dla.dda.bussines;

import com.dla.dda.domain.model.email.DetalleCorreoVO;
import com.dla.dda.domain.model.email.EmailModelVO;
import com.dla.dda.domain.model.email.MessageAttachment;
import com.dla.dda.domain.model.request.EmailRequest;
import com.dla.dda.domain.model.response.EmailResponse;
import com.dla.dda.persistence.dao.BaseDAO;
import com.dla.dda.persistence.model.DdaTContratoDocto;
import com.dla.dda.utils.email.client.EmailService;
import com.dla.dda.utils.json.JsonConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.stereotype.Service;

@Service
@PropertySource(value={"classpath:email.properties"})
public class EmailBussines {
    @Qualifier(value="dlaEmailService")
    @Autowired
    private EmailService service;
    @Qualifier(value="presupuestoEmailService")
    @Autowired
    private EmailService presupuestoService;
    @Qualifier(value="autoziacionTemplate")
    @Autowired
    private EmailService autorizacionService;
    @Qualifier(value="noAutorizacionTemplate")
    @Autowired
    private EmailService noAutorizacionService;
    @Qualifier(value="notificaCreacionContrato")
    @Autowired
    private EmailService notificaCreacionContratoService;
    @Qualifier(value="recordatorioTemplate")
    @Autowired
    private EmailService notificaRecordatorio;
    @Qualifier(value="finalizoAutorizacionTemplate")
    @Autowired
    private EmailService finalizoAutorizacion;
    @Value(value="${email.alternativos.destinatarios}")
    private String[] destinatariosAlternativos;
    @Value(value="${email.alternativos:false}")
    private Boolean correosAlternativos;
    @Value(value="${email.respuesta:}")
    private Boolean respuesta;
    @Value(value="${email.ambiente}")
    private String ambiente;
    private static Logger logger = LoggerFactory.getLogger(EmailBussines.class);
    @Autowired
    private BaseDAO baseDAO;

    public EmailResponse enviaCorreo(EmailRequest request) {
        EmailResponse response = new EmailResponse();
        response.setRespuesta("true");
        logger.info("ambiente " + this.ambiente);
        logger.info("respuesta " + this.respuesta);
        logger.info("correosAlternativos " + this.correosAlternativos);
        EmailModelVO model = new EmailModelVO();
        String body = request.getBody();
        DetalleCorreoVO detalleCorreo = null;
        try {
            if (body != null && (detalleCorreo = (DetalleCorreoVO)JsonConverter.fromJson((String)body, DetalleCorreoVO.class)).getIdDocumento() != null) {
                DdaTContratoDocto docto = (DdaTContratoDocto)this.baseDAO.read((Serializable)detalleCorreo.getIdDocumento(), DdaTContratoDocto.class);
                logger.info("path : [{}] -- name : [{}]", (Object)docto.getRutaServidor(), (Object)docto.getIdContratoDocto());
                FileInputStream initialStream = new FileInputStream(new File(docto.getRutaServidor() + docto.getIdContratoDocto()));
                byte[] targetArray = new byte[((InputStream)initialStream).available()];
                ((InputStream)initialStream).read(targetArray);
                request.setAttachmentFilename(docto.getNombreArchivo());
                request.setContentType("application/pdf");
                request.setIos((InputStreamSource)new ByteArrayResource(targetArray));
                ((InputStream)initialStream).close();
            }
            model.setRequest(request);
            MessageAttachment messageAttachment = new MessageAttachment();
            messageAttachment.setToAddres(this.correosAlternativos != null && this.correosAlternativos == true ? this.destinatariosAlternativos : request.getDestinatarios());
            messageAttachment.setSubject(request.getSubject());
            messageAttachment.setFromAdddres(request.getUserName());
            messageAttachment.setAttachmentFilename(request.getAttachmentFilename());
            messageAttachment.setContentType(request.getContentType());
            messageAttachment.setIos(request.getIos());
            switch (request.getOperacion()) {
                case PRESUPUESTOS: {
                    logger.debug("PRESUPUESTOS");
                    model.getRequest().setSubject("PRESPUESTOS");
                    this.presupuestoService.sendMessage((Serializable)model, messageAttachment);
                    break;
                }
                case CONTRATO: {
                    logger.debug("CONTRATO");
                    model.getRequest().setSubject("CONTRATOS");
                    model.setAutorizacion(detalleCorreo);
                    this.autorizacionService.sendMessage((Serializable)model, messageAttachment);
                    break;
                }
                case MINIMO: {
                    logger.debug("MINIMO");
                    model.getRequest().setSubject("MINIMOS");
                    this.service.sendMessage((Serializable)model, messageAttachment);
                    break;
                }
                case NOAUTORIZA: {
                    logger.debug("Opcion : NOAUTORIZA");
                    model.getRequest().setSubject("CONTRATOS");
                    model.setAutorizacion(detalleCorreo);
                    this.noAutorizacionService.sendMessage((Serializable)model, messageAttachment);
                    break;
                }
                case CREACION_CONTRATO: {
                    logger.debug("Opcion : CREACION CONTRATO");
                    model.getRequest().setSubject("CREACION CONTRATO");
                    model.setAutorizacion(detalleCorreo);
                    this.notificaCreacionContratoService.sendMessage((Serializable)model, messageAttachment);
                    break;
                }
                case RECORDATORIO: {
                    logger.debug("Opcion : RECORDATORIO");
                    model.getRequest().setSubject("RECORDATORIO");
                    model.setAutorizacion(detalleCorreo);
                    this.notificaRecordatorio.sendMessage((Serializable)model, messageAttachment);
                    break;
                }
                case FINALIZO_AUTORIZACION: {
                    logger.debug("Opcion : FINALIZO_AUTORIZACION");
                    model.getRequest().setSubject("FINALIZO_AUTORIZACION");
                    model.setAutorizacion(detalleCorreo);
                    this.finalizoAutorizacion.sendMessage((Serializable)model, messageAttachment);
                    break;
                }
                default: {
                    logger.debug("DEFAULT DESDE DLA");
                    this.service.sendMessage((Serializable)model, messageAttachment);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("JSON ERROR [{}]", (Throwable)e);
            if (this.respuesta.booleanValue()) {
                response.setRespuesta("false");
            }
            response.setRespuesta("true");
        }
        return response;
    }
}

