/*
 * Decompiled with CFR 0.152.
 */
package com.dla.dda.bussines;

import com.dla.dda.domain.exceptions.DLAIntegrationException;
import com.dla.dda.domain.model.UserInfo;
import com.dla.dda.domain.model.response.UsuariosResponse;
import com.dla.dda.persistence.model.DdaCArea;
import com.dla.dda.persistence.model.DlaCEmpresa;
import com.dla.dda.persistence.model.DlaCUsuario;
import com.dla.dda.services.UsuariosService;
import com.dla.dda.transforms.UsuariosTransform;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UsuariosBussines {
    @Autowired
    private UsuariosService service;

    public UsuariosResponse findUsuarios() {
        List<DlaCUsuario> usuariosDDA = null;
        ArrayList<UserInfo> usuarios = null;
        UsuariosResponse response = new UsuariosResponse();
        try {
            usuariosDDA = this.service.findUsuarios();
            if (usuariosDDA != null) {
                for (DlaCUsuario usuarioDDA : usuariosDDA) {
                    if (usuarios == null) {
                        usuarios = new ArrayList<UserInfo>();
                    }
                    UserInfo usuario = new UserInfo();
                    usuario = UsuariosTransform.transform(usuarioDDA);
                    DdaCArea area = this.service.findAreaById(new Long(usuarioDDA.getDdaCArea().getIdArea()));
                    DlaCEmpresa empresa = this.service.findEmpresaById(new Long(usuarioDDA.getDlaCEmpresa().getIdEmpresa()));
                    if (area != null) {
                        usuario.setArea(area.getDescArea());
                    }
                    if (empresa != null) {
                        usuario.setEmpresa(empresa.getDescEmpresa());
                    }
                    usuarios.add(usuario);
                }
                response.setUsuarios(usuarios);
            }
        }
        catch (DLAIntegrationException e) {
            e.printStackTrace();
        }
        return response;
    }
}

