
package com.dla.dda.domain.model.email;

import java.io.Serializable;
import java.util.Arrays;

import org.springframework.core.io.InputStreamSource;

/**
 * @see Objeto para mandar un correo electronico con attachment
 * @modified se agregan 2 attachments
 * @author nmontielh
 * @version 1.0
 */
public class MessageAttachment implements Serializable {

	private static final long serialVersionUID = 1L;

	private String[] toAddres;

	private String fromAdddres;

	private InputStreamSource ios;

	private String contentType;

	private String attachmentFilename;

	private String texto;

	private String subject;

	public MessageAttachment(String[] toAddres, String fromAdddres, String texto) {
		super();
		this.toAddres = toAddres;
		this.fromAdddres = fromAdddres;
		this.texto = texto;
	}

	public MessageAttachment() {
		super();
	}

	public String getTexto() {
		return texto;
	}

	public void setTexto(String texto) {
		this.texto = texto;
	}

	public String getAttachmentFilename() {
		return attachmentFilename;
	}

	public void setAttachmentFilename(String attachmentFilename) {
		this.attachmentFilename = attachmentFilename;
	}

	public String[] getToAddres() {
		return toAddres;
	}

	public void setToAddres(String[] toAddres) {
		this.toAddres = toAddres;
	}

	public InputStreamSource getIos() {
		return ios;
	}

	public void setIos(InputStreamSource is) {
		ios = is;
	}

	public String getContentType() {
		return contentType;
	}

	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	public String getFromAdddres() {
		return fromAdddres;
	}

	public void setFromAdddres(String fromAdddres) {
		this.fromAdddres = fromAdddres;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	@Override
	public String toString() {
		return "MessageAttachment [toAddres=" + Arrays.toString(toAddres) + ", fromAdddres=" + fromAdddres
				+ ", contentType=" + contentType + ", attachmentFilename=" + attachmentFilename + ", texto=" + texto
				+ ", subject=" + subject + "]";
	}

}
