package com.dla.dda.jms.sender.test;

import java.io.IOException;
import java.util.Date;

import javax.jms.JMSException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.Test;

import com.dla.dda.domain.constants.Operacion;
import com.dla.dda.domain.model.request.EmailRequest;
import com.dla.dda.utils.date.DateUtils;
import com.dla.dda.utils.json.JsonConverter;

/**
 * @see Prueba unitaria para el envio y recepcion de mensajes de JMS
 * @author montieln
 *
 */
@ContextConfiguration(locations = { "classpath:jms-connect-context.xml", "classpath:dbms-connect-context.xml",
		"classpath:persistence-context.xml", "classpath:beanRefContextTest.xml", "classpath:email-context.xml",
		"classpath:transact-context.xml", "classpath:publisher-jms-context.xml", "classpath:mdp-context.xml" })
public class SenderJMSTest extends AbstractTestNGSpringContextTests {

	private static Logger logger = LoggerFactory.getLogger(SenderJMSTest.class);

	@Qualifier("emailPublisher")
	@Autowired
	private JMSPublisher publisher;

	/**
	 * @throws JMSException
	 * @throws IOException
	 * @throws InterruptedException
	 * @see Prueba unitaria para el envio de msg al Queue
	 */
	@Test(enabled = false)
	public void sendMessageTest() throws JMSException, IOException, InterruptedException {

		logger.info("Prueba de envio");

		for (int i = 0; i < 10; i++) {

			EmailRequest request = createRequest("Correo prueba numero " + i);
			String json = JsonConverter.toJson(request);

			publisher.send(json);
		}

	}

	/**
	 * @see Metodo utileria para crear informacion de request
	 * @param body
	 * @return
	 */
	private EmailRequest createRequest(String body) {

		String fecha = DateUtils.toString(new Date(), "yyyy-MM-dd 'at' HH:mm:ss");
		String[] destinatarios = new String[] { "nmontielh@gmail.com", "montieln@globalhitss.com" };

		EmailRequest request = new EmailRequest();
		request.setBody(body);
		request.setDate(fecha);
		request.setDestinatarios(destinatarios);
		request.setEtiqueta("TAG");
		request.setName("Noe Montiel");
		request.setOperacion(Operacion.PRESUPUESTOS);
		request.setSubject("Correo de prueba");
		request.setToCompany("HITSS");
		request.setUserName("SeraNecesario?");

		return request;
	}

}
