package com.dla.dda.scheduler.task;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.Test;

/**
 * Prueba unitaria que se encarga de cargar todos los contextos para ejecutar
 * una tarea de manera periodica
 * 
 * @author montieln
 *
 */
@ContextConfiguration(locations = { "classpath:dbms-connect-context.xml", "classpath:persistence-context.xml",
		"classpath:beanRefContextTest.xml", "classpath:email-context.xml", "classpath:transact-context.xml",
		"classpath:scheduler-context.xml", "classpath:quartz-context.xml" })
public class DDASchedulerTest extends AbstractTestNGSpringContextTests {

	private static Logger logger = LoggerFactory.getLogger(DDASchedulerTest.class);

	@Test(enabled = false)
	public void executeScheduledTest() throws InterruptedException {

		logger.info("Ejecutando Pool Scheduler");

		// Se deja el loop infinito para ver que se ejecute el cron

		while (true) {
			Thread.sleep(300L);
		}

	}

	
	
}
