package com.dla.dda.services;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import com.dla.dda.domain.constants.ErrorCodes;
import com.dla.dda.domain.exceptions.DLAIntegrationException;
import com.dla.dda.domain.exceptions.utils.ErrorUtils;
import com.dla.dda.persistence.dao.BaseDAO;
import com.dla.dda.persistence.model.DdaCArea;
import com.dla.dda.persistence.model.DlaCEmpresa;
import com.dla.dda.persistence.model.DlaCUsuario;

@Repository
public class UsuariosService {

	@Autowired
	private BaseDAO dao;

	private static Logger logger = LoggerFactory
			.getLogger(UsuariosService.class);

	public List<DlaCUsuario> findUsuarios() throws DLAIntegrationException {

		List<DlaCUsuario> response = null;

		try {

			response = dao.findListByQuery("findUsuarios", DlaCUsuario.class);

		} catch (Exception e) {
			logger.error("Error to findUsuarios [{}]", e.getMessage(), e);
			ErrorCodes error = ErrorCodes.INFRASTRUCTURE;
			ErrorUtils.setMessage(error, e.getMessage());
			throw new DLAIntegrationException(error);
		}
		return response;
	}

	public DdaCArea findAreaById(Long idArea) throws DLAIntegrationException {

		DdaCArea area = null;

		try {

			if (idArea != null)
				area = dao.read(idArea.byteValue(), DdaCArea.class);

		} catch (Exception e) {

			logger.error("Error to get contrato [{}] [{}]", idArea,
					e.getMessage(), e);
			ErrorCodes error = ErrorCodes.INFRASTRUCTURE;
			ErrorUtils.setMessage(error, e.getMessage());
			throw new DLAIntegrationException(error);
		}

		return area;

	}

	public DlaCEmpresa findEmpresaById(Long idEmpresa)
			throws DLAIntegrationException {

		DlaCEmpresa empresa = null;
		try {

			if (idEmpresa != null)
				empresa = dao.read(idEmpresa.intValue(), DlaCEmpresa.class);

		} catch (Exception e) {

			logger.error("Error to get contrato [{}] [{}]", idEmpresa,
					e.getMessage(), e);
			ErrorCodes error = ErrorCodes.INFRASTRUCTURE;
			ErrorUtils.setMessage(error, e.getMessage());
			throw new DLAIntegrationException(error);
		}

		return empresa;
	}

}
