package com.dla.dda.transforms;

import java.util.ArrayList;
import java.util.List;

import com.dla.dda.domain.model.UserInfo;
import com.dla.dda.persistence.model.DlaCUsuario;

public class UsuariosTransform {

	public static List<UserInfo> transform(List<DlaCUsuario> estudiosDDA) {

		List<UserInfo> usuarios = new ArrayList<UserInfo>();

		for (DlaCUsuario usuario : estudiosDDA)
			usuarios.add(transform(usuario));

		return usuarios;
	}

	public static UserInfo transform(DlaCUsuario usuarioDDA) {

		UserInfo usuario = new UserInfo();

		usuario.setEmail(usuarioDDA.getEmail());
		usuario.setMaterno(usuarioDDA.getMaterno());
		usuario.setNombre(usuarioDDA.getNombre());
		usuario.setNombreCompleto(usuarioDDA.getNombre() + " "
				+ usuarioDDA.getPaterno() + " " + usuarioDDA.getMaterno());
		usuario.setPaterno(usuarioDDA.getPaterno());
		usuario.setUsername(usuarioDDA.getExpediente());

		return usuario;
	}
}
