package com.dla.dda.bussines.test;

import java.io.IOException;
import java.text.ParseException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.Test;

import com.dla.dda.domain.exceptions.DLAIntegrationException;
import com.dla.dda.domain.model.request.PresupuestoRequest;
import com.dla.dda.domain.model.response.PresupuestoResponse;
import com.dla.dda.utils.rest.client.IRestClient;

@ContextConfiguration(locations = { "classpath:rest-test-context.xml" })
public class PresupuestoRestTest extends AbstractTestNGSpringContextTests {

	private static Logger logger = LoggerFactory.getLogger(PresupuestoRestTest.class);

	@Qualifier("amortizacionClientService")
	@Autowired
	private IRestClient clientService;

	@Test(enabled = false)
	public void validaPresupuestoTest() throws DLAIntegrationException, IOException, ParseException {

		PresupuestoRequest request = new PresupuestoRequest(984567, 2016, "REAL");

		PresupuestoResponse response = clientService.post(request, PresupuestoResponse.class);

		logger.info("Response [{}]", response);

	}

}
