package com.dla.dda.bussines.test;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.Test;

import com.dla.dda.domain.exceptions.DLAIntegrationException;
import com.dla.dda.domain.model.request.SecurityRequest;
import com.dla.dda.domain.model.response.SecurityResponse;
import com.dla.dda.services.SecurityService;

import junit.framework.TestCase;

/**
 * @see TestCase para probar los mecanismos de seguridad
 * @author montieln
 *
 */
public class SeguridadTest extends BaseTest {

	private static Logger logger = LoggerFactory.getLogger(SeguridadTest.class);

	@Autowired
	private SecurityService service;

	@Test(enabled = false)
	public void autenticaOkTest() throws DLAIntegrationException {

		String user = "luciano";
		String password = "25d55ad283aa400af464c76d713c07ad";

		SecurityRequest request = new SecurityRequest();

		request.setPassword(password);

		request.setUser(user);
		SecurityResponse response = service.login(request);

		logger.info("Auth Ok request [{}] response [{}]", request, response);

	}

	@Test(enabled = false)
	public void autenticaNOkTest() throws DLAIntegrationException {

		String user = "luciano";
		String password = "4bb10b2a9ce0240442aa26306fc4efee";

		SecurityRequest request = new SecurityRequest();

		request.setPassword(password);

		request.setUser(user);
		SecurityResponse response = service.login(request);

		logger.info(" request [{}] response [{}]", request, response);

	}

	@Test(enabled = false)
	public void autenticaNoUserExistTest() throws DLAIntegrationException {

		String user = "montieln";
		String password = "4bb10b2a9ce0240442aa26306fc4efee";

		SecurityRequest request = new SecurityRequest();

		request.setPassword(password);

		request.setUser(user);
		SecurityResponse response = service.login(request);

		logger.info(" request [{}] response [{}]", request, response);

	}

	@Test(enabled = false)
	public void perfilesTest() throws DLAIntegrationException {

		String user = "lucianoe";

		SecurityRequest request = new SecurityRequest();

		request.setUser(user);
		SecurityResponse response = service.findPerfil(request);

		logger.info(" request [{}] response [{}]", request, response);

	}

}
