package com.dla.dda.bussines.utils.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

import com.dla.dda.domain.constants.ErrorCodes;
import com.dla.dda.domain.constants.OrigenCodes;
import com.dla.dda.domain.exceptions.DLAIntegrationException;
import com.dla.dda.domain.model.request.PresupuestoRequest;
import com.dla.dda.transforms.ContratoTransform;
import com.dla.dda.utils.json.JsonConverter;
import com.dla.dda.utils.validator.CollectionsValidator;

public class ContratosMontoExtractTest {

	final private static Logger logger = LoggerFactory.getLogger(ContratosMontoExtractTest.class);

	@Test(enabled = false)
	private void generateJson() throws IOException {

		// contrato=1, anio=0, origenTitulos=ESPEJO
		PresupuestoRequest request = new PresupuestoRequest();
		request.setContrato(1l);
		request.setAnio(0);
		request.setOrigenTitulos(OrigenCodes.ESPEJO.toString());

		String json = JsonConverter.toJson(request);

		logger.info("json [{}]", json);

	}

	@Test(enabled = false)
	private void transformAniosTest() throws DLAIntegrationException {

		// Prueba con el objeto nulo
		List<Object[]> raw = null;

		List<Integer> responseRaw = ContratoTransform.transformYears(raw);

		logger.info(" raw [{}]", responseRaw);

		// Prueba con el objeto vacio
		raw = CollectionsValidator.safeList(raw);
		List<Integer> responseEmpty = ContratoTransform.transformYears(raw);

		logger.info("response Empty [{}]", responseEmpty);

		// Prueba con 1 elemento
		Object[] element1 = new Object[] { 2010, 2015 };
		raw.add(element1);
		List<Integer> responseElement1 = ContratoTransform.transformYears(raw);
		logger.info("response element1 [{}]", responseElement1);

		// Prueba con varios elementos
		Object[] element2 = new Object[] { 2000, 2015 };
		raw.add(element2);
		List<Integer> responseElement2 = ContratoTransform.transformYears(raw);
		logger.info("response element2 [{}]", responseElement2);

	}

	@Test(enabled = false)
	public void errorTest() {

		// Nulo
		List<ErrorCodes> errors = null;
		Boolean errosExist = errors != null && errors.size() > 0;

		logger.info("Error (null) [{}]", errosExist);

		// No nulo sin errores
		errors = new ArrayList<>();
		Boolean errosExist1 = errors != null && errors.size() > 0;
		logger.info("Error (null and empty) [{}]", errosExist1);

		// un error
		errors.add(ErrorCodes.DATA_ERROR);
		Boolean errosExist2 = errors != null && errors.size() > 0;
		logger.info("Error (on error) [{}]", errosExist2);

	}

}
