package com.dla.dda.utils.date;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class DateUtils {

	/**
	 * @see Obtiene el anio con base a un timestamp
	 * @param fecha
	 * @return
	 */
	public static int getYear(Timestamp fecha) {

		Calendar cal = Calendar.getInstance();
		long timeLong = fecha.getTime();
		cal.setTimeInMillis(timeLong);

		return cal.get(Calendar.YEAR);

	}

	/**
	 * @see Obtenemos la fecha inicial del año
	 * @param anio
	 * @return
	 */
	public static Date getInitialDate(int anio) {

		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, anio);
		cal.set(Calendar.DAY_OF_YEAR, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);

		return cal.getTime();
	}

	public static String getInitialDateRaw(int anio) {

		StringBuffer buffer = new StringBuffer("01-01-");
		buffer.append(anio);

		return buffer.toString();
	}

	/**
	 * @see Obtiene el valor de anio
	 * @param fecha
	 * @param format
	 * @return
	 * @throws ParseException
	 */
	public static int getYear(String fecha, String format) throws ParseException {

		DateFormat df = new SimpleDateFormat(format);
		Date date = df.parse(fecha);

		Calendar cal = Calendar.getInstance();
		cal.setTime(date);

		int year = cal.get(Calendar.YEAR);

		return year;
	}

	/**
	 * @see Obtiene el valor del mes
	 * @param fecha
	 * @param format
	 * @return
	 * @throws ParseException
	 */
	public static int getMonth(String fecha, String format) throws ParseException {

		DateFormat df = new SimpleDateFormat(format);
		Date date = df.parse(fecha);

		Calendar cal = Calendar.getInstance();
		cal.setTime(date);

		int month = cal.get(Calendar.MONTH);
		
		return month;
	}

	/**
	 * @see transforma una fecha en el formato dado
	 * @param fecha
	 * @param format
	 * @return
	 */
	public static String toString(Date fecha, String format) {

		DateFormat df = new SimpleDateFormat(format);

		return df.format(fecha);
	}

	/**
	 * @see obtenemos la fecha final del año
	 * @param anio
	 * @return
	 */
	public static Date getEndDate(int anio) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, anio);
		cal.set(Calendar.MONTH, 11);// 11 = diciembre
		cal.set(Calendar.DAY_OF_MONTH, 31);
		cal.set(Calendar.HOUR_OF_DAY, 23);
		cal.set(Calendar.MINUTE, 59);
		cal.set(Calendar.SECOND, 59);

		return cal.getTime();
	}

	public static String getEndDateRaw(int anio) {
		StringBuffer buffer = new StringBuffer("31-12-");
		buffer.append(anio);

		return buffer.toString();
	}
	
	
	/**
	 * @see Se compara si la fecha uno es antes que la fecha dos
	 * @param anio
	 * @return 
	 */
	public static boolean compararFechasSincronizacion(Date inicioCto, Date sincroSap){		
		return inicioCto.before(sincroSap);
	}

	/**
	 * @see Se convierte string a date
	 * @param anio
	 * @return 
	 * @throws ParseException 
	 */
	public static Date string2Date(String fecha, String format) throws ParseException{
		DateFormat df = new SimpleDateFormat(format);
		return df.parse(fecha);        
	}
	
	/**
	 * @see Regresa la diferencia entre dos fechas dada la unidad de medicion de tiempo a valida (Minutos, horas, dias)
	 * @param fechas a comparar y unidad de tiempo
	 * @return  diferencia entre las fechas dada la unidad de tiempo
	 */
	public static long getDateDiff(Date date1, Date date2, TimeUnit timeUnit) {
	    long diffInMillies = date2.getTime() - date1.getTime(); 
	    return timeUnit.convert(diffInMillies,TimeUnit.MILLISECONDS);
	}

}
