/*
 * Decompiled with CFR 0.152.
 */
package com.dla.dda.services;

import com.dla.dda.domain.constants.EstatusEstudio;
import com.dla.dda.domain.constants.QueryRequest;
import com.dla.dda.persistence.dao.BaseDAO;
import com.dla.dda.persistence.model.catalogs.DdaCEstudio;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class EstudiosService {
    @Autowired
    private BaseDAO dao;
    private static final Logger logger = LoggerFactory.getLogger(EstudiosService.class);

    @Transactional
    public List<DdaCEstudio> findEstudios(QueryRequest request) {
        EstatusEstudio status = request.getEstatus() == null ? EstatusEstudio.UNKNOW : request.getEstatus();
        Criteria criteria = this.dao.createCriteria(DdaCEstudio.class);
        switch (status) {
            case AUTORIZADO: {
                criteria.add(Restrictions.isNotNull((String)"idSap"));
                break;
            }
            case VIRTUAL: {
                criteria.add(Restrictions.isNull((String)"idSap"));
                break;
            }
            case UNKNOW: {
                break;
            }
        }
        criteria.addOrder(Order.desc((String)"descEstudio"));
        List estudios = this.dao.getResultsByCriteria(criteria);
        return estudios;
    }

    @Transactional
    public List<DdaCEstudio> findEstudiosByNombre(QueryRequest request) {
        EstatusEstudio status = request.getEstatus() == null ? EstatusEstudio.UNKNOW : request.getEstatus();
        Criteria criteria = this.dao.createCriteria(DdaCEstudio.class);
        switch (status) {
            case AUTORIZADO: {
                criteria.add(Restrictions.isNotNull((String)"idSap"));
                break;
            }
            case VIRTUAL: {
                criteria.add(Restrictions.isNull((String)"idSap"));
                break;
            }
            case UNKNOW: {
                break;
            }
        }
        criteria.add((Criterion)Restrictions.like((String)"descEstudio", (String)("" + request.getPattern() + ""), (MatchMode)MatchMode.ANYWHERE));
        criteria.addOrder(Order.desc((String)"descEstudio"));
        List estudios = this.dao.getResultsByCriteria(criteria);
        return estudios;
    }
}

