/*
 * Decompiled with CFR 0.152.
 */
package com.dla.dda.services;

import com.dla.dda.domain.constants.ErrorCodes;
import com.dla.dda.domain.constants.EstatusContrato;
import com.dla.dda.domain.contrato.BonoFees;
import com.dla.dda.domain.contrato.PeriodoFlat;
import com.dla.dda.domain.contrato.Rango;
import com.dla.dda.domain.contrato.TituloDDA;
import com.dla.dda.domain.exceptions.DLAIntegrationException;
import com.dla.dda.domain.exceptions.utils.ErrorUtils;
import com.dla.dda.persistence.dao.BaseDAO;
import com.dla.dda.persistence.model.DdaTContrato;
import com.dla.dda.persistence.model.DdaTContratoBonoRango;
import com.dla.dda.persistence.model.DdaTContratoPago;
import com.dla.dda.persistence.model.DdaTContratoPagoCateg;
import com.dla.dda.persistence.model.DdaTContratoPagoCosto;
import com.dla.dda.persistence.model.DdaTContratoPagoFlat;
import com.dla.dda.persistence.model.DdaTContratoPagoRango;
import com.dla.dda.persistence.model.DdaTContratoTitulo;
import com.dla.dda.transforms.FeesTransform;
import com.dla.dda.transforms.TitulosTransform;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ContratoService {
    @Autowired
    private BaseDAO dao;
    private static Logger logger = LoggerFactory.getLogger(ContratoService.class);

    public List<DdaTContrato> findContratos(Integer idEstudio) throws DLAIntegrationException {
        Type[] types = new Type[]{IntegerType.INSTANCE, IntegerType.INSTANCE};
        List response = null;
        try {
            response = this.dao.findListByQuery("findContratosVigentesByEstudio", new Object[]{idEstudio, EstatusContrato.VIGENTE.getId()}, types, DdaTContrato.class);
        }
        catch (Exception e) {
            logger.error("Error to findContratosVigentesByEstudio [{}] [{}]", new Object[]{idEstudio, e.getMessage(), e});
            ErrorCodes error = ErrorCodes.INFRASTRUCTURE;
            ErrorUtils.setMessage((ErrorCodes)error, (String)e.getMessage());
            throw new DLAIntegrationException(error);
        }
        return response;
    }

    public List<DdaTContratoPago> findFeesByContratos(Long idContrato) throws DLAIntegrationException {
        Type[] types = new Type[]{LongType.INSTANCE};
        List response = null;
        try {
            response = this.dao.findListByQuery("findPagoByContrato", new Object[]{idContrato}, types, DdaTContratoPago.class);
        }
        catch (Exception e) {
            logger.error("Error to findPagoByContrato [{}] [{}]", new Object[]{idContrato, e.getMessage(), e});
            ErrorCodes error = ErrorCodes.INFRASTRUCTURE;
            ErrorUtils.setMessage((ErrorCodes)error, (String)e.getMessage());
            throw new DLAIntegrationException(error);
        }
        return response;
    }

    public Map<String, List<Rango>> findPeriodosSuscripcionFees(Long idContratoPago) throws DLAIntegrationException {
        Type[] types = new Type[]{LongType.INSTANCE};
        HashMap<String, List<Rango>> periodos = new HashMap<String, List<Rango>>();
        try {
            List response = this.dao.findListByQuery("findSuscriptorFeesByContratoPago", new Object[]{idContratoPago}, types, Object[].class);
            if (response != null) {
                logger.info(" total [{}]", (Object)response.size());
                for (Object[] row : response) {
                    DdaTContratoPagoRango pagoRango = null;
                    DdaTContratoPagoCosto pagoCosto = null;
                    DdaTContratoPagoCateg pagoCateg = null;
                    for (Object entity : row) {
                        if (entity instanceof DdaTContratoPagoRango) {
                            pagoRango = (DdaTContratoPagoRango)entity;
                            continue;
                        }
                        if (entity instanceof DdaTContratoPagoCosto) {
                            pagoCosto = (DdaTContratoPagoCosto)entity;
                            continue;
                        }
                        if (!(entity instanceof DdaTContratoPagoCateg)) continue;
                        pagoCateg = (DdaTContratoPagoCateg)entity;
                    }
                    Map<String, Rango> periodo = FeesTransform.transform(pagoRango, pagoCosto, pagoCateg);
                    FeesTransform.addPeriodoSuscripcion(periodo, periodos);
                }
            }
            logger.info(" periodos [{}]", (Object)periodos.size());
        }
        catch (Exception e) {
            logger.error("Error to findPeriodosSuscripcionFees [{}] [{}]", new Object[]{idContratoPago, e.getMessage(), e});
            ErrorCodes error = ErrorCodes.INFRASTRUCTURE;
            ErrorUtils.setMessage((ErrorCodes)error, (String)e.getMessage());
            throw new DLAIntegrationException(error);
        }
        return periodos;
    }

    public Map<String, List<PeriodoFlat>> findPeriodosFlatFees(Long idContratoPago) throws DLAIntegrationException {
        Type[] types = new Type[]{LongType.INSTANCE};
        HashMap<String, List<PeriodoFlat>> periodos = new HashMap<String, List<PeriodoFlat>>();
        try {
            List response = this.dao.findListByQuery("findFlatFeesByContratoPago", new Object[]{idContratoPago}, types, Object[].class);
            if (response != null) {
                logger.info(" total [{}]", (Object)response.size());
                for (Object[] row : response) {
                    DdaTContratoPagoFlat pagoFlat = null;
                    DdaTContratoPagoCateg categoria = null;
                    for (Object entity : row) {
                        if (entity instanceof DdaTContratoPagoFlat) {
                            pagoFlat = (DdaTContratoPagoFlat)entity;
                            continue;
                        }
                        if (!(entity instanceof DdaTContratoPagoCateg)) continue;
                        categoria = (DdaTContratoPagoCateg)entity;
                    }
                    logger.info("[{}] [{}]", pagoFlat, categoria);
                    Map<String, List<PeriodoFlat>> subperiodo = FeesTransform.transform(pagoFlat, categoria);
                    FeesTransform.addPeriodoFlat(subperiodo, periodos);
                }
            }
            logger.info(" periodos [{}]", (Object)periodos.size());
        }
        catch (Exception e) {
            logger.error("Error to findSuscripcionFees [{}] [{}]", new Object[]{idContratoPago, e.getMessage(), e});
            ErrorCodes error = ErrorCodes.INFRASTRUCTURE;
            ErrorUtils.setMessage((ErrorCodes)error, (String)e.getMessage());
            throw new DLAIntegrationException(error);
        }
        return periodos;
    }

    public BonoFees findBonosFlatFees(Long idContrato) throws DLAIntegrationException {
        Type[] types = new Type[]{LongType.INSTANCE};
        BonoFees bono = new BonoFees();
        HashMap bonos = new HashMap();
        try {
            List response = this.dao.findListByQuery("findBonosFlatFeesByContrato", new Object[]{idContrato}, types, DdaTContratoBonoRango.class);
            if (response != null) {
                logger.info(" total [{}]", (Object)response.size());
                for (DdaTContratoBonoRango row : response) {
                    Rango rango = new Rango(new Integer(row.getDesde()), new Integer(row.getHasta()), new Double(row.getBono()));
                    ArrayList<Rango> rangos = new ArrayList<Rango>();
                    rangos.add(rango);
                    bonos.put(row.getTipoPago(), rangos);
                }
            }
            logger.info(" periodos [{}]", (Object)bonos.size());
        }
        catch (Exception e) {
            logger.error("Error to find Bonos Fees [{}] [{}]", new Object[]{idContrato, e.getMessage(), e});
            ErrorCodes error = ErrorCodes.INFRASTRUCTURE;
            ErrorUtils.setMessage((ErrorCodes)error, (String)e.getMessage());
            throw new DLAIntegrationException(error);
        }
        bono.setRangos(bonos);
        return bono;
    }

    public List<TituloDDA> findTitulos(Long idContrato) throws DLAIntegrationException {
        Type[] types = new Type[]{LongType.INSTANCE};
        ArrayList<TituloDDA> response = new ArrayList<TituloDDA>();
        try {
            List titulosDDA = this.dao.findListByQuery("findTitulosByContrato", new Object[]{idContrato}, types, Object[].class);
            if (titulosDDA != null) {
                for (Object[] row : titulosDDA) {
                    DdaTContratoTitulo titulo = null;
                    DdaTContratoPagoCateg categoria = null;
                    for (Object entity : row) {
                        if (entity instanceof DdaTContratoTitulo) {
                            titulo = (DdaTContratoTitulo)entity;
                            continue;
                        }
                        if (!(entity instanceof DdaTContratoPagoCateg)) continue;
                        categoria = (DdaTContratoPagoCateg)entity;
                    }
                    response.add(TitulosTransform.transform(titulo, categoria));
                }
            }
        }
        catch (Exception e) {
            logger.error("Error to findTitulos [{}] [{}]", new Object[]{idContrato, e.getMessage(), e});
            ErrorCodes error = ErrorCodes.INFRASTRUCTURE;
            ErrorUtils.setMessage((ErrorCodes)error, (String)e.getMessage());
            throw new DLAIntegrationException(error);
        }
        return response;
    }

    public DdaTContrato getContrato(Long idContrato) throws DLAIntegrationException {
        DdaTContrato contrato = null;
        try {
            contrato = (DdaTContrato)this.dao.read((Serializable)idContrato, DdaTContrato.class);
        }
        catch (IOException e) {
            logger.error("Error to get contrato [{}] [{}]", new Object[]{idContrato, e.getMessage(), e});
            ErrorCodes error = ErrorCodes.INFRASTRUCTURE;
            ErrorUtils.setMessage((ErrorCodes)error, (String)e.getMessage());
            throw new DLAIntegrationException(error);
        }
        return contrato;
    }
}

