package com.dla.dda.domain.model.response;

import java.io.Serializable;
import java.util.List;

import com.dla.dda.domain.model.UserInfo;

/**
 * @see Respuesta para las peticiones de seguridad
 * @author montieln
 *
 */
public class SecurityResponse implements Serializable {

	private static final long serialVersionUID = 1L;
	
	private String username;

	private Boolean enabled;

	private List<String> perfil;

	private String detail;
	
	private UserInfo user;

	public SecurityResponse() {
		super();
	}

	public SecurityResponse(String expediente, Boolean enabled, List<String> perfil, String detail) {
		super();
		this.username = expediente;
		this.enabled = enabled;
		this.perfil = perfil;
		this.detail = detail;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public Boolean getEnabled() {
		return enabled;
	}

	public void setEnabled(Boolean enabled) {
		this.enabled = enabled;
	}

	public List<String> getPerfil() {
		return perfil;
	}

	public void setPerfil(List<String> perfil) {
		this.perfil = perfil;
	}

	public String getDetail() {
		return detail;
	}

	public void setDetail(String detail) {
		this.detail = detail;
	}
	

	public UserInfo getUser() {
		return user;
	}

	public void setUser(UserInfo user) {
		this.user = user;
	}

	@Override
	public String toString() {
		return "SecurityResponse [username=" + username + ", enabled=" + enabled + ", perfil=" + perfil
				+ ", detail=" + detail + ", user=" + user + "]";
	}

}
