package com.dla.dda.rest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.dla.dda.bussines.EstudiosBussines;
import com.dla.dda.domain.constants.QueryRequest;
import com.dla.dda.domain.model.response.EstudiosResponse;
import com.dla.dda.utils.transaction.TransactionState;

@Service
public class EstudiosRestService implements IEstudiosRestService {

	private static Logger logger = LoggerFactory.getLogger(EstudiosRestService.class);

	@Autowired
	private EstudiosBussines service;

	@Override
	public EstudiosResponse findEstudios(QueryRequest request) {

		TransactionState.Current().initialize();

		logger.info("findEstudios [{}]", request);

		return service.findEstudios(request);
	}

	@Override
	public EstudiosResponse findEstudiosByNombre(QueryRequest request) {
		// TODO Auto-generated method stub
		TransactionState.Current().initialize();
		return service.findEstudiosByNombre(request);
	}

}
