package com.dla.dda.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import com.dla.dda.domain.constants.QueryRequest;
import com.dla.dda.domain.model.response.EstudiosResponse;

/**
 * @see Servicio Rest para hacer la integracion con DDa para las operaciones con
 *      estudios
 * @author montieln
 *
 */
@Path("/")
public interface IEstudiosRestService {

	@Path("/findEstudios")
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	EstudiosResponse findEstudios(QueryRequest request);
	
	
	@Path("/findEstudiosByNombre")
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	EstudiosResponse findEstudiosByNombre(QueryRequest request);

}