package com.dla.dda.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import com.dla.dda.domain.model.request.SecurityRequest;
import com.dla.dda.domain.model.response.SecurityResponse;

/**
 * @see Servicio para invocar aspectos de seguridad
 * @author montieln
 *
 */
@Path("/")
public interface ISecurityRestService {

	@Path("/login")
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	SecurityResponse login(SecurityRequest request);
	
	
	@Path("/findPerfiles")
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	SecurityResponse findPerfiles(SecurityRequest request);

}