package com.dla.dda.bussines;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.stereotype.Service;

import com.dla.dda.domain.model.email.DetalleCorreoVO;
import com.dla.dda.domain.model.email.EmailModelVO;
import com.dla.dda.domain.model.email.MessageAttachment;
import com.dla.dda.domain.model.request.EmailRequest;
import com.dla.dda.domain.model.response.EmailResponse;
import com.dla.dda.persistence.dao.BaseDAO;
import com.dla.dda.persistence.model.DdaTContratoDocto;
import com.dla.dda.utils.email.client.EmailService;
import com.dla.dda.utils.json.JsonConverter;


@Service
@PropertySource("classpath:email.properties")
public class EmailBussines {

	// Se agrega el tipo de servicio a enviar
	@Qualifier("dlaEmailService")
	@Autowired
	private EmailService  service;

	@Qualifier("presupuestoEmailService")
	@Autowired
	private EmailService  presupuestoService;

	@Qualifier("autoziacionTemplate")
	@Autowired
	private EmailService  autorizacionService;

	@Qualifier("noAutorizacionTemplate")
	@Autowired
	private EmailService  noAutorizacionService;

	@Qualifier("notificaCreacionContrato")
	@Autowired
	private EmailService  notificaCreacionContratoService;

	@Qualifier("recordatorioTemplate")
	@Autowired
	private EmailService  notificaRecordatorio;

	@Qualifier("finalizoAutorizacionTemplate")
	@Autowired
	private EmailService  finalizoAutorizacion;

	@Value("${email.alternativos.destinatarios}")
	private String[]      destinatariosAlternativos;

	@Value("${email.alternativos:false}")
	private Boolean       correosAlternativos;
	
	@Value("${email.respuesta:}")
	private Boolean respuesta;

	
	@Value("${email.ambiente}")
	private String      ambiente;
	
	
	
	

	private static Logger logger = LoggerFactory.getLogger(EmailBussines.class);

	@Autowired
	private BaseDAO       baseDAO;

	public EmailResponse enviaCorreo(EmailRequest request) {

		EmailResponse response = new EmailResponse();
		response.setRespuesta("true");

		logger.info("ambiente "+ambiente);
		logger.info("respuesta "+respuesta);
		logger.info("correosAlternativos "+correosAlternativos);

		
		
		/**
		 * Instanciamos el modelo que es quien tiene los datos genericos del correo mas la clase que maneja el cuerpo
		 * del correo
		 */
		EmailModelVO model = new EmailModelVO();
		DdaTContratoDocto docto;
		String body = request.getBody();
		DetalleCorreoVO detalleCorreo = null;

		try {

			if (body != null) {

				detalleCorreo = JsonConverter.fromJson(body, DetalleCorreoVO.class);

				if (detalleCorreo.getIdDocumento() != null) {

					docto = baseDAO.read(detalleCorreo.getIdDocumento(), DdaTContratoDocto.class);
					logger.info("path : [{}] -- name : [{}]", docto.getRutaServidor(), docto.getIdContratoDocto());

					InputStream initialStream = new FileInputStream(new File(docto.getRutaServidor() + docto.getIdContratoDocto()));
					byte[] targetArray = new byte[initialStream.available()];
					initialStream.read(targetArray);

					request.setAttachmentFilename(docto.getNombreArchivo());
					request.setContentType("application/pdf");
					request.setIos(new ByteArrayResource(targetArray));
					initialStream.close();
				}

			}

			model.setRequest(request);
			MessageAttachment messageAttachment = new MessageAttachment();

			// agregamos los destinatarios
			messageAttachment.setToAddres(correosAlternativos != null && 
					 correosAlternativos == true ? destinatariosAlternativos : request.getDestinatarios());
			
			messageAttachment.setSubject(request.getSubject());
			messageAttachment.setFromAdddres(request.getUserName());

			messageAttachment.setAttachmentFilename(request.getAttachmentFilename());
			messageAttachment.setContentType(request.getContentType());
			messageAttachment.setIos(request.getIos());

			// Segun el tipo de operacion vamos a enviar un distinto tipo de
			// correo
			switch (request.getOperacion()) {
				case PRESUPUESTOS:
					logger.debug("PRESUPUESTOS");
					// TODO Implementar el tipo de correo que se requiera
					// Segun el tipo de correo es la clase que va a generar el
					// contenido del cuerpo
					// model.setPresupuestoApartado(JsonConverter.fromJson(request.getBody(),
					// PresupuestoApartadoDTO.class));
					model.getRequest().setSubject("PRESPUESTOS");
					presupuestoService.sendMessage(model, messageAttachment);
					break;
				case CONTRATO:
					logger.debug("CONTRATO");
					model.getRequest().setSubject("CONTRATOS");
					// TODO Implementar el tipo de correo que se requiera
					// Segun el tipo de correo es la clase que va a generar el
					// contenido del cuerpo
					model.setAutorizacion(detalleCorreo);
					autorizacionService.sendMessage(model, messageAttachment);
					break;
				case MINIMO:
					logger.debug("MINIMO");
					model.getRequest().setSubject("MINIMOS");
					// TODO Implementar el tipo de correo que se requiera
					// Segun el tipo de correo es la clase que va a generar el
					// contenido del cuerpo
					// model.setAutorizacion(JsonConverter.fromJson(request.getBody(),
					// MinimoVO.class));
					service.sendMessage(model, messageAttachment);
					break;
				case NOAUTORIZA:
					logger.debug("Opcion : NOAUTORIZA");
					model.getRequest().setSubject("CONTRATOS");
					model.setAutorizacion(detalleCorreo);
					noAutorizacionService.sendMessage(model, messageAttachment);
					break;
				case CREACION_CONTRATO:
					logger.debug("Opcion : CREACION CONTRATO");
					model.getRequest().setSubject("CREACION CONTRATO");
					model.setAutorizacion(detalleCorreo);
					notificaCreacionContratoService.sendMessage(model, messageAttachment);
					break;

				case RECORDATORIO:
					logger.debug("Opcion : RECORDATORIO");
					model.getRequest().setSubject("RECORDATORIO");
					model.setAutorizacion(detalleCorreo);
					notificaRecordatorio.sendMessage(model, messageAttachment);
					break;
				case FINALIZO_AUTORIZACION:
					logger.debug("Opcion : FINALIZO_AUTORIZACION");
					model.getRequest().setSubject("FINALIZO_AUTORIZACION");
					model.setAutorizacion(detalleCorreo);
					finalizoAutorizacion.sendMessage(model, messageAttachment);
					break;
				default:
					// TODO Implementar el tipo de correo que se requiera
					logger.debug("DEFAULT DESDE DLA");
					service.sendMessage(model, messageAttachment);
					break;

			}

		}
		catch (Exception e) {
			logger.error("JSON ERROR [{}]", e);
			if(respuesta)
				response.setRespuesta("false");
			else
			    response.setRespuesta("true");
		}
		//response.setRespuesta("true");
		return response;
	}

}
