package com.dla.dda.transforms;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.dla.dda.domain.constants.ErrorCodes;
import com.dla.dda.domain.contrato.ContratoDDA;
import com.dla.dda.domain.exceptions.DLAIntegrationException;
import com.dla.dda.domain.exceptions.utils.ErrorUtils;
import com.dla.dda.persistence.model.DdaTContrato;
import com.dla.dda.utils.date.DateUtils;
import com.dla.dda.utils.validator.CollectionsValidator;

public class ContratoTransform {

	private static Logger logger = LoggerFactory.getLogger(ContratoTransform.class);

	/**
	 * @see Metodo que nos trae el arreglo con los anios que hay en un rango
	 * @param raw
	 * @return
	 */
	public static List<Integer> transformYears(List<Object[]> raw) throws DLAIntegrationException {

		List<Integer> anios = new ArrayList<>();

		if (!CollectionsValidator.safeList(raw).isEmpty()) {

			Object[] data = raw.get(0);

			if (data[0] == null || data[1] == null) {
				ErrorCodes error = ErrorCodes.DATA_NOT_EXIST;
				ErrorUtils.setMessage(error, "No se encontraron fecha inicial   [" + data[0] + "] o final [" + data[1]
						+ "] para el contrato ");

				throw new DLAIntegrationException(error);
			}

			// TODO revisar si llegan como date o en que formato llega

			logger.info(" data[0] [{}] data [1] [{}]", data[0], data[1]);

			Timestamp initDate = (Timestamp) data[0];
			Timestamp endDate = (Timestamp) data[1];

			Integer begin = DateUtils.getYear(initDate);
			Integer end = DateUtils.getYear(endDate);

			for (int anio = begin; anio <= end; anio++) {
				anios.add(anio);
			}

		}

		return anios;
	}







	/**
	 * @see Transformador para el tipo de DDA
	 * @param contratosDDA
	 * @return
	 */
	public static List<ContratoDDA> transformToResponse(List<DdaTContrato> contratosDDA) {

		List<ContratoDDA> contratos = new ArrayList<>();

		for (DdaTContrato contratoDDA : contratosDDA) {

			// Transformamos
			ContratoDDA contrato = transformToResponse(contratoDDA);
			contratos.add(contrato);

		}

		return contratos;
	}

	public static ContratoDDA transformToResponse(DdaTContrato contratoDDA) {

		ContratoDDA contrato = new ContratoDDA();

		logger.info("transformToResponse");

		if (contratoDDA.getIdEstudio() != null)
			contrato.setIdEstudio(contratoDDA.getIdEstudio().longValue());

		logger.info("{}", contratoDDA.getFechaFin());
		contrato.setFechaFin(contratoDDA.getFechaFin().toString());
		
		logger.info("{}", contratoDDA.getFechaInicio());
		contrato.setFechaInicio(contratoDDA.getFechaInicio().toString());

		// TODO se pasa a null esperando poder hacer el transform de este objeto
		contrato.setFeesDDA(null);

		// TODO se pasa a null debiod a que no se espera que venga dato alguno
		if (contratoDDA.getDdaTApartado() != null)
			contrato.setIdApartado(contratoDDA.getDdaTApartado().getIdApartado().longValue());

		if (contratoDDA.getIdContratoOriginal() != null)
			contrato.setIdContratoOriginal(contratoDDA.getIdContratoOriginal().longValue());

		if (contratoDDA.getIdContrato() != null)
			contrato.setIdCtoDDA(contratoDDA.getIdContrato().longValue());


		contrato.setNumeroContrato(contratoDDA.getNumeroContrato());
		contrato.setTipoContrato((int) contratoDDA.getIdTipoContrato());
		
		if (contratoDDA.getFechaAutorizacion() != null)
		    contrato.setFechaDDA(contratoDDA.getFechaAutorizacion().toString());
		// List<TituloDDA> tituloDDA;
		// if(contratoDDA.gettitu)
		// TODO cambiar a un tipo, no se sabe aqui que debe ir
		contrato.setTituloDDA(null);

		return contrato;
	}

}