package com.dla.dda.transforms;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.BeanUtils;

import com.dla.dda.domain.model.response.EstudioDDA;
import com.dla.dda.persistence.model.catalogs.DdaCEstudio;

/**
 * @see Transformador para los estudios
 * @author montieln
 *
 */
public class EstudiosTransform {

	/**
	 * @see Transforma un conjunto de estudios
	 * @param estudiosDDA
	 * @return
	 */
	public static List<EstudioDDA> transform(List<DdaCEstudio> estudiosDDA) {

		List<EstudioDDA> estudios = new ArrayList<>();

		for (DdaCEstudio estudioDDA : estudiosDDA) {

			EstudioDDA estudio = transform(estudioDDA);
			estudios.add(estudio);

		}

		return estudios;
	}

	/**
	 * @see Creamos un objeto Estudio que representa DDA
	 * @param estudioDDA
	 * @return
	 */
	public static EstudioDDA transform(DdaCEstudio estudioDDA) {

		EstudioDDA estudio = new EstudioDDA();

		BeanUtils.copyProperties(estudioDDA, estudio);

		return estudio;
	}

}
