package com.dla.dda.bussines.test;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.Test;

import com.dla.dda.domain.constants.EstatusEstudio;
import com.dla.dda.domain.constants.QueryRequest;
import com.dla.dda.domain.model.response.EstudioDDA;
import com.dla.dda.persistence.model.catalogs.DdaCEstudio;
import com.dla.dda.services.EstudiosService;
import com.dla.dda.transforms.EstudiosTransform;

public class EstudiosTest extends BaseTest {

	final private static Logger logger = LoggerFactory.getLogger(EstudiosTest.class);

	@Autowired
	private EstudiosService service;

	@Test(enabled = false)
	public void findAllEstudiosTest() {

		QueryRequest request = new QueryRequest();
		request.setEstatus(EstatusEstudio.VIRTUAL);

		List<DdaCEstudio> estudios = service.findEstudios(request);

		logger.info("Find All Estudios [{}]", estudios.size());

		List<EstudioDDA> response = EstudiosTransform.transform(estudios);
		
		
		for(EstudioDDA r : response)
			System.out.println(r);

		logger.info("Estudios transformados [{}]", response.size());
		
		

	}

	@Test(enabled = false)
	public void findVirtualesEstudiosTest() {

		QueryRequest request = new QueryRequest();
		request.setEstatus(EstatusEstudio.AUTORIZADO);

		List<DdaCEstudio> estudios = service.findEstudios(request);
		for (DdaCEstudio e : estudios) {
			logger.info("id [{}]  estudio [{}]", e.getIdEstudio(), e.getDescEstudio());
		}

		logger.info("Find Estudios Virtuales [{}]", estudios.size());

	}

	@Test(enabled = false)
	public void findSapEstudiosTest() {

		QueryRequest request = new QueryRequest();
		request.setEstatus(EstatusEstudio.AUTORIZADO);

		List<DdaCEstudio> estudios = service.findEstudios(request);
		for (DdaCEstudio e : estudios) {
			logger.info("id [{}]", e.getIdEstudio());
		}

		logger.info("Find Estudios SAP [{}]", estudios.size());

	}

	@Test(enabled = false)
	public void findAllEstudiosByNameTest() {

		QueryRequest request = new QueryRequest();
		request.setEstatus(EstatusEstudio.UNKNOW);
		request.setPattern("AMX");

		List<DdaCEstudio> estudios = service.findEstudiosByNombre(request);
		for (DdaCEstudio e : estudios) {
			logger.info("e: ", e);
		}

		for (DdaCEstudio estudio : estudios) {
			logger.info(" Tipo [{}] [{}]", estudio.getDescEstudio(), estudio.getIdSap());
		}

		logger.info("Find Estudios SAP [{}]", estudios.size());

	}

}
