/*
 * Decompiled with CFR 0.152.
 */
package com.dla.dda.utils.date;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class DateUtils {
    public static int getYear(Timestamp fecha) {
        Calendar cal = Calendar.getInstance();
        long timeLong = fecha.getTime();
        cal.setTimeInMillis(timeLong);
        return cal.get(1);
    }

    public static Date getInitialDate(int anio) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, anio);
        cal.set(6, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static String getInitialDateRaw(int anio) {
        StringBuffer buffer = new StringBuffer("01-01-");
        buffer.append(anio);
        return buffer.toString();
    }

    public static int getYear(String fecha, String format) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(format);
        Date date = df.parse(fecha);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        return year;
    }

    public static int getMonth(String fecha, String format) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(format);
        Date date = df.parse(fecha);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2);
        return month;
    }

    public static String toString(Date fecha, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(fecha);
    }

    public static Date getEndDate(int anio) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, anio);
        cal.set(2, 11);
        cal.set(5, 31);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static String getEndDateRaw(int anio) {
        StringBuffer buffer = new StringBuffer("31-12-");
        buffer.append(anio);
        return buffer.toString();
    }

    public static boolean compararFechasSincronizacion(Date inicioCto, Date sincroSap) {
        return inicioCto.before(sincroSap);
    }

    public static Date string2Date(String fecha, String format) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.parse(fecha);
    }

    public static long getDateDiff(Date date1, Date date2, TimeUnit timeUnit) {
        long diffInMillies = date2.getTime() - date1.getTime();
        return timeUnit.convert(diffInMillies, TimeUnit.MILLISECONDS);
    }
}

