/*
 * Decompiled with CFR 0.152.
 */
package com.dla.dda.bussines;

import com.dla.dda.domain.constants.FeesType;
import com.dla.dda.domain.contrato.BonoFees;
import com.dla.dda.domain.contrato.ContratoDDA;
import com.dla.dda.domain.contrato.FeesDDA;
import com.dla.dda.domain.contrato.FeesFlat;
import com.dla.dda.domain.contrato.FeesSuscriptor;
import com.dla.dda.domain.contrato.PeriodoFlat;
import com.dla.dda.domain.contrato.Rango;
import com.dla.dda.domain.contrato.TituloDDA;
import com.dla.dda.domain.exceptions.DLAIntegrationException;
import com.dla.dda.persistence.model.DdaTContrato;
import com.dla.dda.persistence.model.DdaTContratoPago;
import com.dla.dda.services.ContratoService;
import com.dla.dda.transforms.ContratoTransform;
import com.dla.dda.transforms.FeesTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContratoBussines {
    private static Logger logger = LoggerFactory.getLogger(ContratoBussines.class);
    @Autowired
    private ContratoService contratoService;

    public List<ContratoDDA> getContratosXEstudio(Integer idEstudio) throws DLAIntegrationException {
        logger.info("getContratosXEstudio");
        List<DdaTContrato> contratosDDA = this.contratoService.findContratos(idEstudio);
        logger.info("{}", contratosDDA);
        List<ContratoDDA> response = ContratoTransform.transformToResponse(contratosDDA);
        logger.info("{}", response);
        return response;
    }

    public ContratoDDA getContratoDetalle(Long idContrato) throws DLAIntegrationException {
        ContratoDDA contratoDetalle = new ContratoDDA();
        DdaTContrato contrato = this.contratoService.getContrato(idContrato);
        contratoDetalle = ContratoTransform.transformToResponse(contrato);
        List<DdaTContratoPago> fees = this.contratoService.findFeesByContratos(idContrato);
        FeesDDA feesDDA = this.getFees(contrato, fees);
        contratoDetalle.setFeesDDA(feesDDA);
        List<TituloDDA> titulos = this.contratoService.findTitulos(idContrato);
        contratoDetalle.setTituloDDA(titulos);
        return contratoDetalle;
    }

    public FeesDDA getFees(DdaTContrato contrato, List<DdaTContratoPago> fees) throws DLAIntegrationException {
        FeesDDA feesDDA = new FeesDDA();
        ArrayList<FeesSuscriptor> suscriFees = new ArrayList<FeesSuscriptor>();
        FeesFlat flatFees = new FeesFlat();
        HashMap<String, List<PeriodoFlat>> periodosFlat = new HashMap<String, List<PeriodoFlat>>();
        block4: for (DdaTContratoPago pago : fees) {
            Long idContratoPago = (long)pago.getIdContratoPago();
            String tipoPago = pago.getTipoPago();
            logger.info(" [{}] [{}]", (Object)idContratoPago, (Object)tipoPago);
            FeesType type = FeesType.getType((String)pago.getTipoPago());
            switch (type) {
                case SUSCRIPCION: {
                    Map<String, List<Rango>> periodosSuscripcion = this.contratoService.findPeriodosSuscripcionFees(idContratoPago);
                    FeesSuscriptor suscriptor = FeesTransform.adapt(pago, periodosSuscripcion);
                    suscriFees.add(suscriptor);
                    continue block4;
                }
                case FLAT: {
                    Map<String, List<PeriodoFlat>> periodos = this.contratoService.findPeriodosFlatFees(idContratoPago);
                    FeesTransform.adaptPeriodosFlatFees(periodosFlat, pago, periodos);
                    continue block4;
                }
            }
            logger.error("Tipo desconocido [{}]", (Object)type);
        }
        flatFees.setPeriodos(periodosFlat);
        feesDDA.setSuscriptor(suscriFees);
        feesDDA.setFlat(flatFees);
        BonoFees bono = this.contratoService.findBonosFlatFees(contrato.getIdContrato());
        feesDDA.setBono(bono);
        return feesDDA;
    }
}

