/*
 * Decompiled with CFR 0.152.
 */
package com.dla.dda.transforms;

import com.dla.dda.domain.constants.ErrorCodes;
import com.dla.dda.domain.contrato.ContratoDDA;
import com.dla.dda.domain.exceptions.DLAIntegrationException;
import com.dla.dda.domain.exceptions.utils.ErrorUtils;
import com.dla.dda.persistence.model.DdaTContrato;
import com.dla.dda.utils.date.DateUtils;
import com.dla.dda.utils.validator.CollectionsValidator;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContratoTransform {
    private static Logger logger = LoggerFactory.getLogger(ContratoTransform.class);

    public static List<Integer> transformYears(List<Object[]> raw) throws DLAIntegrationException {
        ArrayList<Integer> anios = new ArrayList<Integer>();
        if (!CollectionsValidator.safeList(raw).isEmpty()) {
            Object[] data = raw.get(0);
            if (data[0] == null || data[1] == null) {
                ErrorCodes error = ErrorCodes.DATA_NOT_EXIST;
                ErrorUtils.setMessage((ErrorCodes)error, (String)("No se encontraron fecha inicial   [" + data[0] + "] o final [" + data[1] + "] para el contrato "));
                throw new DLAIntegrationException(error);
            }
            logger.info(" data[0] [{}] data [1] [{}]", data[0], data[1]);
            Timestamp initDate = (Timestamp)data[0];
            Timestamp endDate = (Timestamp)data[1];
            Integer begin = DateUtils.getYear((Timestamp)initDate);
            Integer end = DateUtils.getYear((Timestamp)endDate);
            for (int anio = begin.intValue(); anio <= end; ++anio) {
                anios.add(anio);
            }
        }
        return anios;
    }

    public static List<ContratoDDA> transformToResponse(List<DdaTContrato> contratosDDA) {
        ArrayList<ContratoDDA> contratos = new ArrayList<ContratoDDA>();
        for (DdaTContrato contratoDDA : contratosDDA) {
            ContratoDDA contrato = ContratoTransform.transformToResponse(contratoDDA);
            contratos.add(contrato);
        }
        return contratos;
    }

    public static ContratoDDA transformToResponse(DdaTContrato contratoDDA) {
        ContratoDDA contrato = new ContratoDDA();
        if (contratoDDA.getIdEstudio() != null) {
            contrato.setIdEstudio(Long.valueOf(contratoDDA.getIdEstudio()));
        }
        contrato.setFechaFin(contratoDDA.getFechaFin().toString());
        contrato.setFechaInicio(contratoDDA.getFechaInicio().toString());
        contrato.setFeesDDA(null);
        if (contratoDDA.getDdaTApartado() != null) {
            contrato.setIdApartado(Long.valueOf(contratoDDA.getDdaTApartado().getIdApartado()));
        }
        if (contratoDDA.getIdContratoOriginal() != null) {
            contrato.setIdContratoOriginal(Long.valueOf(contratoDDA.getIdContratoOriginal()));
        }
        if (contratoDDA.getIdContrato() != null) {
            contrato.setIdCtoDDA(Long.valueOf(contratoDDA.getIdContrato()));
        }
        contrato.setNumeroContrato(contratoDDA.getNumeroContrato());
        contrato.setTipoContrato(Integer.valueOf(contratoDDA.getIdTipoContrato()));
        contrato.setFechaDDA(contratoDDA.getFechaAutorizacion().toString());
        contrato.setTituloDDA(null);
        return contrato;
    }
}

