package com.dla.dda.domain.exceptions;

import com.dla.dda.domain.constants.ErrorCodes;

/**
 * @see interface para manejar los diferentes tipos de error del siste,a
 * @author montieln
 *
 */
public class DLAIntegrationException extends Exception {

	private static final long serialVersionUID = 1L;

	private ErrorCodes error;

	public DLAIntegrationException(ErrorCodes error) {
		super();
		this.error = error;
	}

	public ErrorCodes getError() {
		return error;
	}

	@Override
	public String getMessage() {

		String messageError = "[" + error + "][" + error.getCode() + "]" + "[" + error.getDetail() + "]";

		return messageError + "[" + super.getMessage() + "]";
	}

}
