package com.dla.dda.domain.model.response;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.dla.dda.domain.constants.ErrorCodes;
import com.dla.dda.domain.model.TitulosMonto;

/**
 * @see Modelo que representa al presupuesto
 * @author montieln
 *
 */
public class PresupuestoResponse implements Serializable {

	private static final long serialVersionUID = 1L;

	private Double amortizable;

	private Double contratado;

	private Double disponible;

	// Solo traer el del contrato que me consultaron
	private Double amortizableEstudio;

	// contratado Estudio
	private Double contratoEstudio;

	// la resta que en el disponible anterior
	private Double disponibleEstudio;

	//
	private Double valorContrato;

	private List<TitulosMonto> listaTitulos;// Titulo y valor en ese año

	private String estatus;

	private String msg;

	private List<ErrorCodes> error = new ArrayList<>();

	public PresupuestoResponse() {
		super();

	}

	public PresupuestoResponse(double amortizable, double contratado, double disponible, double amortizableEstudio,
			double contratoEstudio, double disponibleEstudio, double valorContrato, List<TitulosMonto> listaTitulos,
			String estatus, String msg) {
		super();
		this.amortizable = amortizable;
		this.contratado = contratado;
		this.disponible = disponible;
		this.amortizableEstudio = amortizableEstudio;
		this.contratoEstudio = contratoEstudio;
		this.disponibleEstudio = disponibleEstudio;
		this.valorContrato = valorContrato;
		this.listaTitulos = listaTitulos;
		this.estatus = estatus;
		this.msg = msg;
	}

	public Double getAmortizable() {
		return amortizable;
	}

	public void setAmortizable(Double amortizable) {
		this.amortizable = amortizable;
	}

	public Double getContratado() {
		return contratado;
	}

	public void setContratado(Double contratado) {
		this.contratado = contratado;
	}

	public Double getDisponible() {
		return disponible;
	}

	public void setDisponible(Double disponible) {
		this.disponible = disponible;
	}

	public Double getAmortizableEstudio() {
		return amortizableEstudio;
	}

	public void setAmortizableEstudio(Double amortizableEstudio) {
		this.amortizableEstudio = amortizableEstudio;
	}

	public Double getContratoEstudio() {
		return contratoEstudio;
	}

	public void setContratoEstudio(Double contratoEstudio) {
		this.contratoEstudio = contratoEstudio;
	}

	public Double getDisponibleEstudio() {
		return disponibleEstudio;
	}

	public void setDisponibleEstudio(Double disponibleEstudio) {
		this.disponibleEstudio = disponibleEstudio;
	}

	public Double getValorContrato() {
		return valorContrato;
	}

	public void setValorContrato(Double valorContrato) {
		this.valorContrato = valorContrato;
	}

	public List<TitulosMonto> getListaTitulos() {
		return listaTitulos;
	}

	public void setListaTitulos(List<TitulosMonto> listaTitulos) {
		this.listaTitulos = listaTitulos;
	}

	public String getEstatus() {
		return estatus;
	}

	public void setEstatus(String estatus) {
		this.estatus = estatus;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public List<ErrorCodes> getError() {
		return error;
	}

	public void setError(List<ErrorCodes> error) {
		this.error = error;
	}

	@Override
	public String toString() {
		return "PresupuestoResponse [amortizable=" + amortizable + ", contratado=" + contratado + ", disponible="
				+ disponible + ", amortizableEstudio=" + amortizableEstudio + ", contratoEstudio=" + contratoEstudio
				+ ", disponibleEstudio=" + disponibleEstudio + ", valorContrato=" + valorContrato + ", estatus="
				+ estatus + ", msg=" + msg + ", error=" + error + "]";
	}



}
