package com.dla.dda.rest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.dla.dda.domain.exceptions.DLAIntegrationException;
import com.dla.dda.domain.model.request.SecurityRequest;
import com.dla.dda.domain.model.response.SecurityResponse;
import com.dla.dda.services.SecurityService;
import com.dla.dda.utils.transaction.TransactionState;

@Service
public class SecurityRestService implements ISecurityRestService {

	private static Logger logger = LoggerFactory.getLogger(SecurityRestService.class);

	@Autowired
	private SecurityService service;

	@Override
	public SecurityResponse login(SecurityRequest request) {
		TransactionState.Current().initialize();

		logger.info(" login test [{}]", request);

		SecurityResponse response = null;
		try {
			response = service.login(request);
		} catch (DLAIntegrationException e) {
			logger.error("Error al realizar la autenticacion [{}]", e.getMessage(), e);
		}

		return response;
	}

	@Override
	public SecurityResponse findPerfiles(SecurityRequest request) {

		TransactionState.Current().initialize();

		logger.info(" findPerfiles [{}]", request);

		SecurityResponse response = null;
		try {
			response = service.findPerfil(request);
		} catch (DLAIntegrationException e) {
			logger.error("Error al consultar los perfiles [{}]", e.getMessage(), e);
		}

		return response;

	}

}
