package com.dla.dda.bussines;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.dla.dda.domain.constants.QueryRequest;
import com.dla.dda.domain.model.response.EstudioDDA;
import com.dla.dda.domain.model.response.EstudiosResponse;
import com.dla.dda.persistence.model.catalogs.DdaCEstudio;
import com.dla.dda.services.EstudiosService;
import com.dla.dda.transforms.EstudiosTransform;

@Service
public class EstudiosBussines {

	@Autowired
	private EstudiosService service;

	public EstudiosResponse findEstudios(QueryRequest request) {

		List<DdaCEstudio> estudiosDDA = service.findEstudios(request);

		List<EstudioDDA> estudios = EstudiosTransform.transform(estudiosDDA);

		EstudiosResponse response = new EstudiosResponse();
		response.setEstudios(estudios);

		return response;
	}
	
	public EstudiosResponse findEstudiosByNombre(QueryRequest request) {

		List<DdaCEstudio> estudiosDDA = service.findEstudiosByNombre(request);

		List<EstudioDDA> estudios = EstudiosTransform.transform(estudiosDDA);

		EstudiosResponse response = new EstudiosResponse();
		response.setEstudios(estudios);

		return response;
	}

}
