package com.dla.dda.transforms;

import com.dla.dda.domain.contrato.TituloDDA;
import com.dla.dda.persistence.model.DdaTContratoPagoCateg;
import com.dla.dda.persistence.model.DdaTContratoTitulo;

public class TitulosTransform {

	public static TituloDDA transform(DdaTContratoTitulo tituloDDA, DdaTContratoPagoCateg categoriaDDA) {

		TituloDDA titulo = new TituloDDA();

		// TODO pendiente

		if (categoriaDDA != null)
			titulo.setCategoriaTarifa(categoriaDDA.getDescCategoria());

		titulo.setClasificacion("");

		if (tituloDDA.getEpisodio() != null && !tituloDDA.getEpisodio().isEmpty())
			titulo.setEpisodio(tituloDDA.getEpisodio());

		// TODO ajustar los transformadores
		titulo.setFechaInicioExhibicion(tituloDDA.getFechaInicio());
		titulo.setFechaFinExhibicion(tituloDDA.getFechaFin());
		// titulo.setIdCtoOrig();
		titulo.setNombre(tituloDDA.getNombreUnico());
		titulo.setTemporada(tituloDDA.getTemporada());
		titulo.setTipo(tituloDDA.getTipoTitulo());
		titulo.setIdBroadview(tituloDDA.getIdBv());

		if (tituloDDA.getIdCategoriaTit() != null)
			titulo.setIdCategoria(tituloDDA.getIdCategoriaTit().toString());

		if (tituloDDA.getIdTituloCntorig() != null)
			titulo.setIdCtoOrig(tituloDDA.getIdTituloCntorig().longValue());

		if (tituloDDA.getCosto() != null && !tituloDDA.getCosto().isEmpty())
			titulo.setCosto(Double.valueOf(tituloDDA.getCosto()));

		return titulo;

	}

}
