package com.dla.dda.bussines.test;

import java.util.HashSet;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

import com.dla.dda.utils.validator.CollectionsValidator;

/**
 * @see Prueba unitaria para las validaciones
 * @author montieln
 *
 */
public class ToolsTest {

	private static Logger logger = LoggerFactory.getLogger(ToolsTest.class);

	@Test(enabled = false)
	public void esParcialNoEncontradoTest() {

		Boolean isParcial = true;

		Long idTitulo = 150L;

		Set<Long> idTitulosProcesar = null;

		idTitulosProcesar = CollectionsValidator.safeSet(idTitulosProcesar);

		if (isParcial && !idTitulosProcesar.contains(idTitulo))
			logger.info(" Es parcial y no se encuentra");
		else
			logger.info(" es parcial [{}] lo contiene [{}]", isParcial, idTitulosProcesar.contains(idTitulo));

	}

	@Test(enabled = false)
	public void esParcialSeEncuentra() {

		Boolean isParcial = true;

		Long idTitulo = 150L;

		Set<Long> idTitulosProcesar = new HashSet<>();
		idTitulosProcesar.add(150L);

		if (isParcial && !idTitulosProcesar.contains(idTitulo))
			logger.info(" Es parcial y no se encuentra");
		else
			logger.info(" es parcial [{}] lo contiene [{}]", isParcial, idTitulosProcesar.contains(idTitulo));

	}

	@Test(enabled = false)
	public void esCompletoSeEncuentra() {

		Boolean isParcial = true;

		Long idTitulo = 160L;

		Set<Long> idTitulosProcesar = new HashSet<>();
		idTitulosProcesar.add(150L);

		if (isParcial && !idTitulosProcesar.contains(idTitulo))
			logger.info(" Es parcial y no se encuentra");
		else
			logger.info(" es parcial [{}] lo contiene [{}]", isParcial, idTitulosProcesar.contains(idTitulo));

	}

}
