package com.dla.dda.bussines.utils.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.dla.dda.domain.model.TitulosMonto;

/**
 * @see Clase para crear datos de prueba para las pruebas unitarias
 * @author montieln
 *
 */
public class DataFactory {

	/**
	 * @see Metodo que trae un listado con los anios a usar
	 * @param initialYear
	 * @param endYear
	 * @return
	 */
	public List<Integer> getAnios(int initialYear, int endYear) {

		List<Integer> anios = new ArrayList<>();

		for (int i = initialYear; i <= endYear; i++) {

			anios.add(i);

		}
		return anios;

	}

	/**
	 * @see Metodo que crea un mapa con el detalle por anio y titulo
	 * @param initialYear
	 * @param endYear
	 * @return
	 */
	public Map<Integer, List<TitulosMonto>> createListMonto(int initialYear, int endYear) {

		Map<Integer, List<TitulosMonto>> resultado = new HashMap<Integer, List<TitulosMonto>>();

		for (int i = initialYear; i <= endYear; i++) {

			List<TitulosMonto> listado = createListado();
			resultado.put(i, listado);

		}

		return resultado;
	}

	/**
	 * @see Metodo que crea un listado por cada mes con el detalle del titulo
	 * @return
	 */
	public List<TitulosMonto> createListado() {
		List<TitulosMonto> total = new ArrayList<>();
		int idInt = 248846;
		for (int i = 0; i < 12; i++) {

			String id = (idInt + i) + "";
			Double monto = 100d * i;

			TitulosMonto titulo = new TitulosMonto();
			titulo.setIdTitulo(id);
			titulo.setMonto(monto);

			total.add(titulo);
		}

		return total;
	}

}
