package com.dla.dda.utils.rest.client;

import java.io.IOException;

public interface IRestClient {

	/**
	 * @see request por metodo post
	 * @param request
	 *            : objeto del tipo RequestDTO
	 * @param path
	 *            : ruta del servicio
	 * @param requestClass
	 *            Tipo class de respuesta
	 * @return
	 */
	public abstract <Response, Request> Response post(String path, Request request, Class<Response> responseClass)
			throws IOException;

	public abstract <Response, Request> Response post(Request request, Class<Response> responseClass)
			throws IOException;

	public abstract <Response, Request> Response post(String request, Class<Response> responseClass) throws IOException;

	/**
	 * 
	 * @param path
	 * @param request
	 * @param responseClass
	 * @return
	 */
	public abstract <Response, Request> Response put(String path, Request request, Class<Response> responseClass)
			throws IOException;

	/**
	 * @see se hace el uso sin path
	 * @param request
	 * @param responseClass
	 * @return
	 */
	public abstract <Response, Request> Response put(Request request, Class<Response> responseClass) throws IOException;

	/**
	 * @see Metodo de invocacion get
	 * @param request
	 * @param responseClass
	 * @return
	 * @throws IOException
	 */
	//public abstract <Response, Request> Response get(Request request, Class<Response> responseClass) throws IOException;

}