package com.dla.dda.utils.transaction;

import java.util.UUID;

import org.slf4j.MDC;

/**
 * @see entrega el thread id.
 * 
 * @author nmontielh
 */
public final class TransactionState {

	public static final String transactionId = "transactionId";

	private static ThreadLocal<TransactionState> sessionForCurrentThread = new ThreadLocal<TransactionState>() {
		@Override
		public TransactionState initialValue() {
			return new TransactionState();
		}
	};

	public static TransactionState Current() {
		return sessionForCurrentThread.get();
	}

	/**
	 * @see Metodo para generar un id random e inicializarlo como valor del
	 *      thread
	 */
	public String initialize() {

		String value = UUID.randomUUID().toString();

		MDC.put(transactionId, value);
		return value;
	}

}