package com.dla.dda.utils.validator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CollectionsValidator {

	/**
	 * @see nos entrega una collecion vacia si es nulo
	 * @param other
	 * @return
	 */
	public static <T> List<T> safeList(final List<T> other) {

		return other == null ? new ArrayList<T>() : other;

	}

	/**
	 * @see nos entrega un set vacio si es nulo
	 * @param other
	 * @return
	 */
	public static <T> Set<T> safeSet(final Set<T> other) {

		return other == null ? new HashSet<T>() : other;

	}

	/**
	 * @see Entrega el valor del elemento de lo contrario entrega null si el
	 *      elemento esta index of boud
	 * @param other
	 * @param element
	 * @return
	 */
	public static <T> T getElement(List<T> other, Integer element) {

		other = safeList(other);

		if ((element + 1) <= other.size()) {
			return other.get(element);
		} else
			return null;

	}

}
