/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapHeaderException;
import org.springframework.ws.soap.saaj.SaajSoapHeader;
import org.springframework.ws.soap.saaj.SaajSoapHeaderElement;
import org.springframework.ws.soap.saaj.SaajSoapHeaderException;
import org.springframework.ws.soap.soap12.Soap12Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SaajSoap12Header
extends SaajSoapHeader
implements Soap12Header {
    SaajSoap12Header(SOAPHeader header) {
        super(header);
    }

    @Override
    public SoapHeaderElement addNotUnderstoodHeaderElement(QName headerName) {
        try {
            SOAPHeaderElement headerElement = this.getImplementation().addNotUnderstoodHeaderElement(this.getSaajHeader(), headerName);
            return new SaajSoapHeaderElement(headerElement);
        }
        catch (SOAPException ex) {
            throw new SaajSoapHeaderException(ex);
        }
    }

    @Override
    public SoapHeaderElement addUpgradeHeaderElement(String[] supportedSoapUris) {
        try {
            SOAPHeaderElement headerElement = this.getImplementation().addUpgradeHeaderElement(this.getSaajHeader(), supportedSoapUris);
            return new SaajSoapHeaderElement(headerElement);
        }
        catch (SOAPException ex) {
            throw new SaajSoapHeaderException(ex);
        }
    }

    @Override
    public Iterator<SoapHeaderElement> examineHeaderElementsToProcess(String[] roles, boolean isUltimateDestination) throws SoapHeaderException {
        ArrayList<SOAPHeaderElement> result = new ArrayList<SOAPHeaderElement>();
        Iterator<SOAPHeaderElement> iterator = this.getImplementation().examineAllHeaderElements(this.getSaajHeader());
        while (iterator.hasNext()) {
            SOAPHeaderElement saajHeaderElement = iterator.next();
            String headerRole = saajHeaderElement.getRole();
            if (!this.shouldProcess(headerRole, roles, isUltimateDestination)) continue;
            result.add(saajHeaderElement);
        }
        return new SaajSoapHeader.SaajSoapHeaderElementIterator(result.iterator());
    }

    private boolean shouldProcess(String headerRole, String[] roles, boolean isUltimateDestination) {
        if (!StringUtils.hasLength((String)headerRole)) {
            return true;
        }
        if ("http://www.w3.org/2003/05/soap-envelope/role/next".equals(headerRole)) {
            return true;
        }
        if ("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver".equals(headerRole)) {
            return isUltimateDestination;
        }
        if ("http://www.w3.org/2003/05/soap-envelope/role/none".equals(headerRole)) {
            return false;
        }
        if (!ObjectUtils.isEmpty((Object[])roles)) {
            for (String role : roles) {
                if (!role.equals(headerRole)) continue;
                return true;
            }
        }
        return false;
    }
}

