package mx.com.amx.mx.dda.crn.bo;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;

import javax.xml.ws.WebServiceException;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.soap.client.SoapFaultClientException;

import com.americamovil.dda._1.f.enviaactivofijo.DTActivoFijo;
import com.americamovil.dda._1.f.enviaactivofijo.DTActivoFijoRes;
import com.americamovil.dda._1.f.enviacontenido.DTContenido;
import com.americamovil.dda._1.f.enviacontenido.DTContenidoRes;

import mx.com.amx.mx.dda.crn.dao.DDACargaAddOnsDAO;
import mx.com.amx.mx.dda.crn.dto.ContratoTituloDTO;
import mx.com.amx.mx.dda.crn.dto.DatosCntTituloExhibicionDTO;
import mx.com.amx.mx.dda.crn.dto.ItemActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParamActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParametroDTO;
import mx.com.amx.mx.dda.crn.dto.RespSAPActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.RespSAPNotificaAFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ResponseOrdenCompraDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoCrearActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ResultadoNotificacionDTO;
import mx.com.amx.mx.dda.crn.dto.StringManager;
import mx.com.amx.mx.dda.crn.dto.TransactionFaultDTO;
import mx.com.amx.mx.dda.crn.utils.DateManager;



public class DDACargaAddOnsBO 
{
	private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	private final String ARCHIVO_PROPIEDADES 	= "/general.properties";
	Properties env 	= 	new Properties();
	DateManager dateManager = new DateManager();
	StringManager strManager = new StringManager();
	
	@Autowired
	@Qualifier("wsNotificaAFijoSAP")
	private WebServiceTemplate wsNotificaAFijoSAP;
	
	private DDACargaAddOnsDAO dao;
	
	private String AMBIENTE;
	private String SERVIDOR;
	private String PUERTO;
	private String COMPONENTE;
	private String ERROR_COMUNICACION_SAP;
	private String ERROR_INTERNO_SAP;
	private String ERROR_PROCESO;
	private String ERROR_REGISTRO_SAP;
	private String FECHA_TEST;
	
	
	public DDACargaAddOnsBO() 
	{
		super();
		try
		{
			env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
			AMBIENTE = env.getProperty("ambiente");
			SERVIDOR = env.getProperty(AMBIENTE+".servidor.sap.ws");
			PUERTO = env.getProperty(AMBIENTE+".puerto.sap.ws");
			COMPONENTE = "DDA_CRN_Exhibicion::" + this.getClass().getSimpleName();
			ERROR_COMUNICACION_SAP = env.getProperty("error.comunicacion.sap");
			ERROR_INTERNO_SAP = env.getProperty("error.interno.sap");
			ERROR_PROCESO = env.getProperty("error.proceso");
			FECHA_TEST = env.getProperty("fecha.test");
		}
		catch(Exception e)
		{
			LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );
		}
	}
	
	public boolean existeProcesoNotificacionEjecutandose() throws Exception 
	{
		LOG.debug("    - ["+this.getClass().getSimpleName()+"::existeProcesoNotificacionEjecutandose]");
		boolean resultado = false;
		try
		{
			resultado = getDao().verificaEjecutandoseProcesoNotificacion();
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::existeProcesoNotificacionEjecutandose]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	
	
	


	public boolean ejecutarSPAmortizacionReal() throws Exception {
		
		LOG.debug("    - ["+this.getClass().getSimpleName()+"::ejecutarSPAmortizacionReal]");
		
		boolean resultado = false;
		try
		{
			resultado = getDao().ejecutarSPAmortizacionReal(); 
		}
		catch(Exception e)
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarSPAmortizacionReal]: "+e.getMessage() );
			throw new Exception(e.getMessage());
		}
		return resultado;		
	}

    /**
     * @return the dao
     */
    public DDACargaAddOnsDAO getDao() {
        return dao;
    }

    /**
     * @param dao the dao to set
     */
    public void setDao(DDACargaAddOnsDAO dao) {
        this.dao = dao;
    }
	
}
