/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import oracle.core.lmx.CoreException;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.Datum;
import oracle.sql.LnxLib;
import oracle.sql.LnxLibForServer;
import oracle.sql.LnxLibThin;

public class NUMBER
extends Datum {
    private static final byte[] MAX_LONG = NUMBER.toBytes(Long.MAX_VALUE);
    private static final byte[] MIN_LONG = NUMBER.toBytes(Long.MIN_VALUE);
    private static final byte[] MAX_INT = NUMBER.toBytes(Integer.MAX_VALUE);
    private static final byte[] MIN_INT = NUMBER.toBytes(Integer.MIN_VALUE);
    private static final byte[] MAX_SHORT = NUMBER.toBytes((short)Short.MAX_VALUE);
    private static final byte[] MIN_SHORT = NUMBER.toBytes((short)Short.MIN_VALUE);
    private static final byte[] MAX_BYTE = NUMBER.toBytes((byte)127);
    private static final byte[] MIN_BYTE = NUMBER.toBytes((byte)-128);
    private static final int CHARACTER_ZERO = 48;
    private static final BigDecimal BIGDEC_NEGZERO = new BigDecimal("-0");
    private static final BigDecimal BIGDEC_ZERO = BigDecimal.valueOf(0L);
    private static final BigDecimal BIGDEC_ONE = BigDecimal.valueOf(1L);
    private static final BigInteger BIGINT_ZERO = BigInteger.valueOf(0L);
    private static final BigInteger BIGINT_HUND = BigInteger.valueOf(100L);
    private static final byte DIGEND = 21;
    private static final byte ODIGEND = 9;
    private static final int HUNDIGMAX = 66;
    private static final int BIGINTARRAYMAX = 54;
    private static final double BIGRATIO = 0.1505149978319906;
    private static final int BIGLENMAX = 22;
    static final byte LNXM_NUM = 22;
    static final int LNXSGNBT = 128;
    static final byte LNXDIGS = 20;
    static final byte LNXEXPBS = 64;
    static final double ORANUM_FBASE = 100.0;
    static final int LNXBASE = 100;
    static final byte IEEE_DBL_DIG = 15;
    private static final byte IEEE_FLT_DIG = 6;
    static final int LNXEXPMX = 127;
    static final int LNXEXPMN = 0;
    static final int LNXMXOUT = 40;
    static final int LNXMXFMT = 64;
    private static final byte[] PI = new byte[]{-63, 4, 15, 16, 93, 66, 36, 90, 80, 33, 39, 47, 27, 44, 39, 33, 80, 51, 29, 85, 21};
    private static final byte[] E = new byte[]{-63, 3, 72, 83, 82, 83, 85, 60, 5, 53, 36, 37, 3, 88, 48, 14, 53, 67, 25, 98, 77};
    private static final byte[] LN10 = new byte[]{-63, 3, 31, 26, 86, 10, 30, 95, 5, 57, 85, 2, 80, 92, 46, 47, 85, 37, 43, 8, 61};
    private static LnxLib _slnxlib;
    private static LnxLib _thinlib;
    private static int DBL_MAX;
    private static int INT_MAX;
    private static float FLOAT_MAX_INT;
    private static float FLOAT_MIN_INT;
    private static double DOUBLE_MAX_INT;
    private static double DOUBLE_MIN_INT;
    private static double DOUBLE_MAX_INT_2;
    private static double DOUBLE_MIN_INT_2;
    private static Object drvType;
    private static String LANGID;
    static final long serialVersionUID = -1656085588913430059L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final boolean TRACE = false;

    public NUMBER() {
        super(NUMBER._makeZero());
    }

    public NUMBER(byte[] byArray) {
        super(byArray);
    }

    public NUMBER(byte by) {
        super(NUMBER.toBytes(by));
    }

    public NUMBER(int n2) {
        super(NUMBER.toBytes(n2));
    }

    public NUMBER(long l2) {
        super(NUMBER.toBytes(l2));
    }

    public NUMBER(short s2) {
        super(NUMBER.toBytes(s2));
    }

    public NUMBER(float f2) {
        super(NUMBER.toBytes(f2));
    }

    public NUMBER(double d2) throws SQLException {
        super(NUMBER.toBytes(d2));
    }

    public NUMBER(BigDecimal bigDecimal) throws SQLException {
        super(NUMBER.toBytes(bigDecimal));
    }

    public NUMBER(BigInteger bigInteger) throws SQLException {
        super(NUMBER.toBytes(bigInteger));
    }

    public NUMBER(String string, int n2) throws SQLException {
        super(NUMBER.toBytes(string, n2));
    }

    public NUMBER(boolean bl) {
        super(NUMBER.toBytes(bl));
    }

    public NUMBER(Object object) throws SQLException {
        if (object instanceof Integer) {
            this.setShareBytes(NUMBER.toBytes((Integer)object));
        } else if (object instanceof Long) {
            this.setShareBytes(NUMBER.toBytes((Long)object));
        } else if (object instanceof Float) {
            this.setShareBytes(NUMBER.toBytes(((Float)object).floatValue()));
        } else if (object instanceof Double) {
            this.setShareBytes(NUMBER.toBytes((Double)object));
        } else if (object instanceof BigInteger) {
            this.setShareBytes(NUMBER.toBytes((BigInteger)object));
        } else if (object instanceof BigDecimal) {
            this.setShareBytes(NUMBER.toBytes((BigDecimal)object));
        } else if (object instanceof Boolean) {
            this.setShareBytes(NUMBER.toBytes((Boolean)object));
        } else if (object instanceof String) {
            this.setShareBytes(this.stringToBytes((String)object));
        } else if (object instanceof Short) {
            this.setShareBytes(NUMBER.toBytes((Short)object));
        } else if (object instanceof Byte) {
            this.setShareBytes(NUMBER.toBytes((Byte)object));
        } else {
            throw new SQLException("Initialization failed");
        }
    }

    public static double toDouble(byte[] byArray) {
        if (NUMBER._isZero(byArray)) {
            return 0.0;
        }
        if (NUMBER._isPosInf(byArray)) {
            return Double.POSITIVE_INFINITY;
        }
        if (NUMBER._isNegInf(byArray)) {
            return Double.NEGATIVE_INFINITY;
        }
        String string = null;
        try {
            string = drvType == null ? _slnxlib.lnxnuc(byArray, DBL_MAX, null) : _slnxlib.lnxnuc(byArray, DBL_MAX, LANGID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        double d2 = Double.valueOf(string);
        return d2;
    }

    public static float toFloat(byte[] byArray) {
        return (float)NUMBER.toDouble(byArray);
    }

    private static long toLongInternal(byte[] byArray, byte[] byArray2, byte[] byArray3) throws SQLException {
        if (NUMBER._isZero(byArray)) {
            return 0L;
        }
        if (NUMBER._isInf(byArray) || NUMBER.compareBytes(byArray, byArray2) > 0 || NUMBER.compareBytes(byArray, byArray3) < 0) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        return NUMBER._getLnxLib().lnxsni(byArray);
    }

    public static long toLong(byte[] byArray) throws SQLException {
        return NUMBER.toLongInternal(byArray, MAX_LONG, MIN_LONG);
    }

    public static int toInt(byte[] byArray) throws SQLException {
        return (int)NUMBER.toLongInternal(byArray, MAX_INT, MIN_INT);
    }

    public static short toShort(byte[] byArray) throws SQLException {
        return (short)NUMBER.toLongInternal(byArray, MAX_SHORT, MIN_SHORT);
    }

    public static byte toByte(byte[] byArray) throws SQLException {
        return (byte)NUMBER.toLongInternal(byArray, MAX_BYTE, MIN_BYTE);
    }

    public static BigInteger toBigInteger(byte[] byArray) throws SQLException {
        int n2;
        long[] lArray = new long[10];
        int n3 = 9;
        int n4 = 1;
        int n5 = 0;
        if (NUMBER._isZero(byArray)) {
            return BIGINT_ZERO;
        }
        if (NUMBER._isInf(byArray)) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        boolean bl = NUMBER._isPositive(byArray);
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        if (byArray2[0] < 0) {
            return BIGINT_ZERO;
        }
        int n6 = n2 = Math.min(byArray2[0] + 1, byArray2.length - 1);
        if ((n2 & 1) == 1) {
            lArray[n3] = byArray2[n4];
            n4 = (byte)(n4 + 1);
            --n6;
        } else {
            lArray[n3] = byArray2[n4] * 100 + byArray2[n4 + 1];
            n4 = (byte)(n4 + 2);
            n6 -= 2;
        }
        int n7 = n3;
        while (n6 != 0) {
            long l2 = byArray2[n4] * 100 + byArray2[n4 + 1];
            for (n3 = 9; n3 >= n7; n3 = (int)((byte)(n3 - 1))) {
                lArray[n3] = (l2 += lArray[n3] * 10000L) & 0xFFFFL;
                l2 >>= 16;
            }
            if (l2 != 0L) {
                // empty if block
            }
            n7 = (byte)(n7 - 1);
            lArray[n7] = l2;
            n4 = (byte)(n4 + 2);
            n6 -= 2;
        }
        int n8 = lArray[n7] >> 8 != 0L ? 2 * (9 - n7) + 2 : 2 * (9 - n7) + 1;
        byte[] byArray3 = new byte[n8];
        if ((n8 & 1) == 1) {
            byArray3[n5] = (byte)lArray[n7];
            ++n5;
        } else {
            byArray3[n5] = (byte)(lArray[n7] >> 8);
            byArray3[++n5] = (byte)(lArray[n7] & 0xFFL);
            ++n5;
        }
        for (n7 = (int)((byte)(n7 + 1)); n7 <= 9; n7 = (int)((byte)(n7 + 1))) {
            byArray3[n5] = (byte)(lArray[n7] >> 8);
            byArray3[n5 + 1] = (byte)(lArray[n7] & 0xFFL);
            n5 += 2;
        }
        BigInteger bigInteger = new BigInteger(bl ? 1 : -1, byArray3);
        int n9 = byArray2[0] - (n2 - 1);
        return bigInteger.multiply(BIGINT_HUND.pow(n9));
    }

    public static BigDecimal toBigDecimal(byte[] byArray) throws SQLException {
        int n2;
        long[] lArray = new long[10];
        int n3 = 9;
        int n4 = 1;
        int n5 = 0;
        if (NUMBER._isZero(byArray)) {
            return BIGDEC_ZERO;
        }
        if (NUMBER._isInf(byArray)) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        boolean bl = NUMBER._isPositive(byArray);
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        int n6 = n2 = byArray2.length - 1;
        if ((n2 & 1) == 1) {
            lArray[n3] = byArray2[n4];
            n4 = (byte)(n4 + 1);
            --n6;
        } else {
            lArray[n3] = byArray2[n4] * 100 + byArray2[n4 + 1];
            n4 = (byte)(n4 + 2);
            n6 -= 2;
        }
        int n7 = n3;
        while (n6 != 0) {
            long l2 = byArray2[n4] * 100 + byArray2[n4 + 1];
            for (n3 = 9; n3 >= n7; n3 = (int)((byte)(n3 - 1))) {
                lArray[n3] = (l2 += lArray[n3] * 10000L) & 0xFFFFL;
                l2 >>= 16;
            }
            if (l2 != 0L) {
                // empty if block
            }
            n7 = (byte)(n7 - 1);
            lArray[n7] = l2;
            n4 = (byte)(n4 + 2);
            n6 -= 2;
        }
        int n8 = lArray[n7] >> 8 != 0L ? 2 * (9 - n7) + 2 : 2 * (9 - n7) + 1;
        byte[] byArray3 = new byte[n8];
        if ((n8 & 1) == 1) {
            byArray3[n5] = (byte)lArray[n7];
            ++n5;
        } else {
            byArray3[n5] = (byte)(lArray[n7] >> 8);
            byArray3[++n5] = (byte)(lArray[n7] & 0xFFL);
            ++n5;
        }
        for (n7 = (int)((byte)(n7 + 1)); n7 <= 9; n7 = (int)((byte)(n7 + 1))) {
            byArray3[n5] = (byte)(lArray[n7] >> 8);
            byArray3[n5 + 1] = (byte)(lArray[n7] & 0xFFL);
            n5 += 2;
        }
        BigInteger bigInteger = new BigInteger(bl ? 1 : -1, byArray3);
        BigDecimal bigDecimal = new BigDecimal(bigInteger);
        int n9 = byArray2[0] - n2 + 1;
        bigDecimal = bigDecimal.movePointRight(n9 * 2);
        if (n9 < 0 && byArray2[n2] % 10 == 0) {
            bigDecimal = bigDecimal.setScale(-(n9 * 2 + 1));
        }
        return bigDecimal;
    }

    public static String toString(byte[] byArray) {
        int n2;
        int n3 = 0;
        if (NUMBER._isZero(byArray)) {
            return "0";
        }
        if (NUMBER._isPosInf(byArray)) {
            return new Double(Double.POSITIVE_INFINITY).toString();
        }
        if (NUMBER._isNegInf(byArray)) {
            return new Double(Double.NEGATIVE_INFINITY).toString();
        }
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        int n4 = byArray2[0];
        int n5 = n4 - ((n2 = byArray2.length - 1) - 1);
        int n6 = n5 >= 0 ? 2 * (n4 + 1) + 1 : (n4 >= 0 ? 2 * (n2 + 1) : 2 * (n2 - n4) + 3);
        char[] cArray = new char[n6];
        if (!NUMBER._isPositive(byArray)) {
            cArray[n3++] = 45;
        }
        if (n5 >= 0) {
            n3 += NUMBER._byteToChars(byArray2[1], cArray, n3);
            int n7 = 2;
            while (n7 <= n2) {
                NUMBER._byteTo2Chars(byArray2[n7], cArray, n3);
                n3 += 2;
                ++n7;
                --n4;
            }
            if (n4 > 0) {
                while (n4 > 0) {
                    cArray[n3++] = 48;
                    cArray[n3++] = 48;
                    --n4;
                }
            }
        } else {
            int n8 = n2 + n5;
            if (n8 > 0) {
                int n9;
                n3 += NUMBER._byteToChars(byArray2[1], cArray, n3);
                if (n8 == 1) {
                    cArray[n3++] = 46;
                }
                for (n9 = 2; n9 < n2; ++n9) {
                    NUMBER._byteTo2Chars(byArray2[n9], cArray, n3);
                    n3 += 2;
                    if (n8 != n9) continue;
                    cArray[n3++] = 46;
                }
                if (byArray2[n9] % 10 == 0) {
                    n3 += NUMBER._byteToChars((byte)(byArray2[n9] / 10), cArray, n3);
                } else {
                    NUMBER._byteTo2Chars(byArray2[n9], cArray, n3);
                    n3 += 2;
                }
            } else {
                int n10;
                cArray[n3++] = 48;
                cArray[n3++] = 46;
                while (n8 < 0) {
                    cArray[n3++] = 48;
                    cArray[n3++] = 48;
                    ++n8;
                }
                for (n10 = 1; n10 < n2; ++n10) {
                    NUMBER._byteTo2Chars(byArray2[n10], cArray, n3);
                    n3 += 2;
                }
                if (byArray2[n10] % 10 == 0) {
                    n3 += NUMBER._byteToChars((byte)(byArray2[n10] / 10), cArray, n3);
                } else {
                    NUMBER._byteTo2Chars(byArray2[n10], cArray, n3);
                    n3 += 2;
                }
            }
        }
        return new String(cArray, 0, n3);
    }

    public static boolean toBoolean(byte[] byArray) {
        return !NUMBER._isZero(byArray);
    }

    public static byte[] toBytes(double d2) throws SQLException {
        if (Double.isNaN(d2)) {
            throw new IllegalArgumentException(CoreException.getMessage((byte)11));
        }
        if (d2 == 0.0 || d2 == -0.0) {
            return NUMBER._makeZero();
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return NUMBER._makePosInf();
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return NUMBER._makeNegInf();
        }
        return NUMBER._getThinLib().lnxren(d2);
    }

    public static byte[] toBytes(float f2) {
        if (Float.isNaN(f2)) {
            throw new IllegalArgumentException(CoreException.getMessage((byte)11));
        }
        if (f2 == 0.0f || f2 == -0.0f) {
            return NUMBER._makeZero();
        }
        if (f2 == Float.POSITIVE_INFINITY) {
            return NUMBER._makePosInf();
        }
        if (f2 == Float.NEGATIVE_INFINITY) {
            return NUMBER._makeNegInf();
        }
        String string = Float.toString(f2);
        try {
            return NUMBER._getLnxLib().lnxcpn(string, false, 0, false, 0, "AMERICAN_AMERICA");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] toBytes(long l2) {
        return NUMBER._getLnxLib().lnxmin(l2);
    }

    public static byte[] toBytes(int n2) {
        return NUMBER.toBytes((long)n2);
    }

    public static byte[] toBytes(short s2) {
        return NUMBER.toBytes((long)s2);
    }

    public static byte[] toBytes(byte by) {
        return NUMBER.toBytes((long)by);
    }

    public static byte[] toBytes(BigInteger bigInteger) throws SQLException {
        int n2;
        long l2;
        int n3;
        int n4;
        byte[] byArray;
        Object object;
        if (bigInteger == null) {
            SQLException sQLException = DatabaseError.createSqlException(null, 68, "input should not be null");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        byte[] byArray2 = new byte[66];
        long[] lArray = new long[54];
        long[] lArray2 = new long[22];
        int n5 = 21;
        int n6 = 0;
        int n7 = 21;
        boolean bl = false;
        int n8 = 0;
        boolean bl2 = true;
        if (bigInteger.signum() == 0) {
            return NUMBER._makeZero();
        }
        if (bigInteger.signum() == -1) {
            object = bigInteger.abs();
            bl2 = false;
            byArray = ((BigInteger)object).toByteArray();
            n4 = (int)Math.floor((double)((BigInteger)object).bitLength() * 0.1505149978319906);
        } else {
            byArray = bigInteger.toByteArray();
            n4 = (int)Math.floor((double)bigInteger.bitLength() * 0.1505149978319906);
        }
        if (bigInteger.abs().compareTo(BIGINT_HUND.pow(n4)) < 0) {
            --n4;
        }
        if (byArray.length > 54) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        for (n3 = 0; n3 < byArray.length; ++n3) {
            lArray[n3] = byArray[n3] < 0 ? (long)(byArray[n3] + 256) : (long)byArray[n3];
        }
        int n9 = byArray.length;
        switch (n9 % 3) {
            case 2: {
                lArray2[n5] = (lArray[n6] << 8) + lArray[n6 + 1];
                n6 = (byte)(n6 + 2);
                n9 -= 2;
                break;
            }
            case 1: {
                lArray2[n5] = lArray[n6];
                n6 = (byte)(n6 + 1);
                --n9;
                break;
            }
            default: {
                l2 = (lArray[n6] << 16) + (lArray[n6 + 1] << 8) + lArray[n6 + 2];
                lArray2[n5] = l2 % 1000000L;
                lArray2[n5 - 1] = l2 / 1000000L;
                n7 = (byte)(n7 - (lArray2[n5 - 1] != 0L ? 1 : 0));
                n6 = (byte)(n6 + 3);
                n9 -= 3;
            }
        }
        while (n9 != 0) {
            l2 = (lArray[n6] << 4) + (lArray[n6 + 1] >> 4);
            for (n5 = 21; n5 >= n7; n5 = (int)((byte)(n5 - 1))) {
                lArray2[n5] = (l2 += lArray2[n5] << 12) % 1000000L;
                l2 /= 1000000L;
            }
            if (l2 != 0L) {
                n7 = (byte)(n7 - 1);
                lArray2[n7] = l2;
            }
            l2 = ((lArray[n6 + 1] & 0xFL) << 8) + lArray[n6 + 2];
            for (n5 = 21; n5 >= n7; n5 = (int)((byte)(n5 - 1))) {
                lArray2[n5] = (l2 += lArray2[n5] << 12) % 1000000L;
                l2 /= 1000000L;
            }
            if (l2 != 0L) {
                n7 = (byte)(n7 - 1);
                lArray2[n7] = l2;
            }
            n6 = (byte)(n6 + 3);
            n9 -= 3;
        }
        byArray2[n8] = (byte)(lArray2[n7] / 10000L);
        if (byArray2[n8] != 0) {
            n2 = 3 * (21 - n7) + 3;
            byArray2[n8 + 1] = (byte)(lArray2[n7] % 10000L / 100L);
            byArray2[n8 + 2] = (byte)(lArray2[n7] % 100L);
            n8 += 3;
        } else {
            byArray2[n8] = (byte)(lArray2[n7] % 10000L / 100L);
            if (byArray2[n8] != 0) {
                n2 = 3 * (21 - n7) + 2;
                byArray2[n8 + 1] = (byte)(lArray2[n7] % 100L);
                n8 += 2;
            } else {
                byArray2[n8] = (byte)lArray2[n7];
                n2 = 3 * (21 - n7) + 1;
                ++n8;
            }
        }
        for (n5 = (int)((byte)(n7 + 1)); n5 <= 21; n5 = (int)((byte)(n5 + 1))) {
            byArray2[n8] = (byte)(lArray2[n5] / 10000L);
            byArray2[n8 + 1] = (byte)(lArray2[n5] % 10000L / 100L);
            byArray2[n8 + 2] = (byte)(lArray2[n5] % 100L);
            n8 += 3;
        }
        for (n3 = n8 - 1; n3 >= 0 && byArray2[n3] == 0; --n3) {
            --n2;
        }
        if (n2 > 19) {
            n3 = 20;
            n2 = 19;
            if (byArray2[n3] >= 50) {
                int n10 = --n3;
                byArray2[n10] = (byte)(byArray2[n10] + 1);
                while (byArray2[n3] == 100) {
                    if (n3 == 0) {
                        ++n4;
                        byArray2[n3] = 1;
                        break;
                    }
                    byArray2[n3] = 0;
                    int n11 = --n3;
                    byArray2[n11] = (byte)(byArray2[n11] + 1);
                }
                for (n3 = n2 - 1; n3 >= 0 && byArray2[n3] == 0; --n3) {
                    --n2;
                }
            }
        }
        if (n4 > 62) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        object = new byte[n2 + 1];
        object[0] = (byte)n4;
        System.arraycopy(byArray2, 0, object, 1, n2);
        return NUMBER._toLnxFmt((byte[])object, bl2);
    }

    public static byte[] toBytes(BigDecimal bigDecimal) throws SQLException {
        int n2;
        long l2;
        int n3;
        BigDecimal bigDecimal2;
        if (bigDecimal == null) {
            SQLException sQLException = DatabaseError.createSqlException(null, 68, "input should not be null");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        byte[] byArray = new byte[66];
        long[] lArray = new long[54];
        long[] lArray2 = new long[22];
        int n4 = 21;
        int n5 = 0;
        int n6 = 21;
        int n7 = 0;
        int n8 = 0;
        BigDecimal bigDecimal3 = bigDecimal.abs();
        int n9 = 0;
        if (bigDecimal.signum() == 0) {
            return NUMBER._makeZero();
        }
        boolean bl = bigDecimal.signum() != -1;
        int n10 = bigDecimal.scale();
        if (n10 < 0) {
            bigDecimal = bigDecimal.setScale(0);
            n10 = 0;
        }
        int n11 = bigDecimal3.compareTo(BIGDEC_ONE);
        int n12 = 0;
        if (n11 == -1) {
            while ((bigDecimal2 = bigDecimal3.movePointRight(++n12)).compareTo(BIGDEC_ONE) < 0) {
            }
            n9 = -n12;
        } else {
            while ((bigDecimal2 = bigDecimal3.movePointLeft(++n12)).compareTo(BIGDEC_ONE) >= 0) {
            }
            n9 = n12;
        }
        byte[] byArray2 = bigDecimal3.movePointRight(n10).toBigInteger().toByteArray();
        if (byArray2.length > 54) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        for (n3 = 0; n3 < byArray2.length; ++n3) {
            lArray[n3] = byArray2[n3] < 0 ? (long)(byArray2[n3] + 256) : (long)byArray2[n3];
        }
        int n13 = byArray2.length;
        switch (n13 % 3) {
            case 2: {
                lArray2[n4] = (lArray[n5] << 8) + lArray[n5 + 1];
                n5 = (byte)(n5 + 2);
                n13 -= 2;
                break;
            }
            case 1: {
                lArray2[n4] = lArray[n5];
                n5 = (byte)(n5 + 1);
                --n13;
                break;
            }
            default: {
                l2 = (lArray[n5] << 16) + (lArray[n5 + 1] << 8) + lArray[n5 + 2];
                lArray2[n4] = l2 % 1000000L;
                lArray2[n4 - 1] = l2 / 1000000L;
                n6 = (byte)(n6 - (lArray2[n4 - 1] != 0L ? 1 : 0));
                n5 = (byte)(n5 + 3);
                n13 -= 3;
            }
        }
        while (n13 != 0) {
            l2 = (lArray[n5] << 4) + (lArray[n5 + 1] >> 4);
            for (n4 = 21; n4 >= n6; n4 = (int)((byte)(n4 - 1))) {
                lArray2[n4] = (l2 += lArray2[n4] << 12) % 1000000L;
                l2 /= 1000000L;
            }
            if (l2 != 0L) {
                n6 = (byte)(n6 - 1);
                lArray2[n6] = l2;
            }
            l2 = ((lArray[n5 + 1] & 0xFL) << 8) + lArray[n5 + 2];
            for (n4 = 21; n4 >= n6; n4 = (int)((byte)(n4 - 1))) {
                lArray2[n4] = (l2 += lArray2[n4] << 12) % 1000000L;
                l2 /= 1000000L;
            }
            if (l2 != 0L) {
                n6 = (byte)(n6 - 1);
                lArray2[n6] = l2;
            }
            n5 = (byte)(n5 + 3);
            n13 -= 3;
        }
        byArray[n7] = (byte)(lArray2[n6] / 10000L);
        if (byArray[n7] != 0) {
            n2 = 3 * (21 - n6) + 3;
            byArray[n7 + 1] = (byte)(lArray2[n6] % 10000L / 100L);
            byArray[n7 + 2] = (byte)(lArray2[n6] % 100L);
            n7 += 3;
        } else {
            byArray[n7] = (byte)(lArray2[n6] % 10000L / 100L);
            if (byArray[n7] != 0) {
                n2 = 3 * (21 - n6) + 2;
                byArray[n7 + 1] = (byte)(lArray2[n6] % 100L);
                n7 += 2;
            } else {
                byArray[n7] = (byte)lArray2[n6];
                n2 = 3 * (21 - n6) + 1;
                ++n7;
            }
        }
        for (n4 = (int)((byte)(n6 + 1)); n4 <= 21; n4 = (int)((byte)(n4 + 1))) {
            byArray[n7] = (byte)(lArray2[n4] / 10000L);
            byArray[n7 + 1] = (byte)(lArray2[n4] % 10000L / 100L);
            byArray[n7 + 2] = (byte)(lArray2[n4] % 100L);
            n7 += 3;
        }
        for (n3 = n7 - 1; n3 >= 0 && byArray[n3] == 0; --n3) {
            --n2;
        }
        if (n10 > 0 && (n10 & 1) != 0) {
            int n14 = n2;
            byte[] byArray3 = new byte[n14 + 1];
            if (byArray[0] <= 9) {
                for (n3 = 0; n3 < n14 - 1; ++n3) {
                    byArray3[n3] = (byte)(byArray[n3] % 10 * 10 + byArray[n3 + 1] / 10);
                }
                byArray3[n3] = (byte)(byArray[n3] % 10 * 10);
                if (byArray3[n14 - 1] == 0) {
                    --n2;
                }
            } else {
                byArray3[n14] = (byte)(byArray[n14 - 1] % 10 * 10);
                for (n3 = n14 - 1; n3 > 0; --n3) {
                    byArray3[n3] = (byte)(byArray[n3] / 10 + byArray[n3 - 1] % 10 * 10);
                }
                byArray3[n3] = (byte)(byArray[n3] / 10);
                if (byArray3[n14] > 0) {
                    ++n2;
                }
            }
            System.arraycopy(byArray3, 0, byArray, 0, n2);
        }
        if (n2 > 20) {
            n3 = 20;
            n2 = 20;
            if (byArray[n3] >= 50) {
                int n15 = --n3;
                byArray[n15] = (byte)(byArray[n15] + 1);
                while (byArray[n3] == 100) {
                    if (n3 == 0) {
                        ++n9;
                        byArray[n3] = 1;
                        break;
                    }
                    byArray[n3] = 0;
                    int n16 = --n3;
                    byArray[n16] = (byte)(byArray[n16] + 1);
                }
            }
            for (n3 = n2 - 1; n3 >= 0 && byArray[n3] == 0; --n3) {
                --n2;
            }
        }
        n8 = n9 <= 0 ? (byArray[0] < 10 ? -(2 - n9) / 2 + 1 : -(2 - n9) / 2) : (n9 - 1) / 2;
        if (n8 > 62) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        if (n8 <= -65) {
            throw new SQLException(CoreException.getMessage((byte)2));
        }
        byte[] byArray4 = new byte[n2 + 1];
        byArray4[0] = (byte)n8;
        System.arraycopy(byArray, 0, byArray4, 1, n2);
        return NUMBER._toLnxFmt(byArray4, bl);
    }

    public static byte[] toBytes(String string, int n2) throws SQLException {
        int n3;
        int n4;
        int n5;
        Object object;
        if (string == null || string.length() == 0) {
            SQLException sQLException = DatabaseError.createSqlException(null, 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n6 = 0;
        int n7 = 0;
        byte[] byArray = new byte[22];
        int n8 = 0;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 40;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = string.indexOf("E");
        if (n17 != -1 || (n17 = string.indexOf("e")) != -1) {
            int n18;
            boolean bl4;
            object = new StringBuffer(string.length() + 5);
            n5 = 0;
            BigDecimal bigDecimal = null;
            boolean bl5 = string.charAt(0) == '-';
            String string2 = string.substring(n17 + 1);
            String string3 = string.substring(bl5 ? 1 : 0, n17);
            bigDecimal = new BigDecimal(string3);
            boolean bl6 = bl4 = string2.charAt(0) == '-';
            if (bl4 || string2.charAt(0) == '+') {
                string2 = string2.substring(1);
            }
            n5 = Integer.parseInt(string2);
            String string4 = bigDecimal.toString();
            int n19 = string4.indexOf(".");
            int n20 = string4.length();
            int n21 = n20--;
            if (n19 != -1) {
                string4 = string4.substring(0, n19) + string4.substring(n19 + 1);
                if (bl4) {
                    n5 -= n19;
                } else {
                    n21 = ++n5;
                }
            } else if (bl4) {
                n5 -= n20;
            } else {
                n21 = ++n5;
            }
            if (bl5) {
                ((StringBuffer)object).append("-");
            }
            if (bl4) {
                ((StringBuffer)object).append("0.");
                for (n18 = 0; n18 < n5; ++n18) {
                    ((StringBuffer)object).append("0");
                }
                ((StringBuffer)object).append(string4);
            } else {
                n18 = n5 > n20 ? n5 : n20;
                for (int i2 = 0; i2 < n18; ++i2) {
                    if (n21 == i2) {
                        ((StringBuffer)object).append(".");
                    }
                    ((StringBuffer)object).append(n20 > i2 ? string4.charAt(i2) : (char)'0');
                }
            }
            string = ((StringBuffer)object).toString();
        }
        string = string.trim();
        int n22 = string.length();
        if (string.charAt(0) == '-') {
            --n22;
            bl = false;
            n15 = 1;
        }
        n6 = n22;
        object = new char[n22];
        string.getChars(n15, n22 + n15, (char[])object, 0);
        for (n4 = 0; n4 < n22; ++n4) {
            if (object[n4] != 46) continue;
            bl3 = true;
            break;
        }
        if (!bl3) {
            n2 = 0;
        }
        while (n7 < n6 && object[n7] == 48) {
            ++n7;
            if (!bl3) continue;
            ++n16;
        }
        if (n7 == n6) {
            return NUMBER._makeZero();
        }
        if (n22 >= 2 && object[n7] == 46) {
            ++n7;
            while (n6 > 0 && object[n6 - 1] == 48) {
                --n6;
            }
            if (n7 == n6) {
                return NUMBER._makeZero();
            }
            --n9;
            while (n7 < n6 - 1 && object[n7] == 48 && object[n7 + 1] == 48) {
                --n9;
                n11 += 2;
                n7 += 2;
            }
            if (n9 < -65) {
                throw new SQLException(CoreException.getMessage((byte)2));
            }
            if (n6 - n7 > n12) {
                n3 = n7 + n12;
                if (n11 > 0) {
                    n3 += n11;
                }
                if (n3 <= n6) {
                    n6 = n3;
                }
                n13 = n6;
                bl2 = true;
            }
            n8 = n6 - n7 >> 1;
            if ((n6 - n7) % 2 != 0) {
                byArray[n8] = (byte)(Integer.parseInt(new String((char[])object, n6 - 1, 1)) * 10);
                ++n10;
                --n6;
            }
            while (n6 > n7) {
                byArray[--n8] = (byte)Integer.parseInt(new String((char[])object, n6 - 2, 2));
                n6 -= 2;
                ++n10;
            }
        } else {
            int n23;
            while (n2 > 0 && n6 > 0 && object[n6 - 1] == 48) {
                --n6;
                --n2;
            }
            if (n2 == 0 && n6 > 1) {
                if (object[n6 - 1] == 46) {
                    --n6;
                }
                if (n7 == n6) {
                    return NUMBER._makeZero();
                }
                while (n6 > 1 && object[n6 - 2] == 48 && object[n6 - 1] == 48) {
                    n6 -= 2;
                    ++n9;
                }
            }
            if (n9 > 62) {
                throw new SQLException(CoreException.getMessage((byte)3));
            }
            if (n6 - n7 - (bl3 ? 1 : 0) > n12) {
                n3 = n12 + (bl3 ? 1 : 0);
                n5 = n6 - n3;
                n6 = n3;
                if ((n2 -= n5) < 0) {
                    n2 = 0;
                }
                bl2 = true;
                n13 = n6;
            }
            int n24 = n23 = n2 == 0 ? n6 - n7 : n6 - n2 - 1;
            if (n16 > 0) {
                n23 -= n16;
            }
            if (n23 % 2 != 0) {
                n14 = Integer.parseInt(new String((char[])object, n7, 1));
                ++n7;
                --n23;
                if (n6 - 1 == n12) {
                    --n2;
                    bl2 = true;
                    n13 = --n6;
                }
            } else {
                n14 = Integer.parseInt(new String((char[])object, n7, 2));
                n7 += 2;
                n23 -= 2;
            }
            byArray[n8] = (byte)n14;
            ++n8;
            ++n10;
            while (n23 > 0) {
                byArray[n8] = (byte)Integer.parseInt(new String((char[])object, n7, 2));
                ++n8;
                n7 += 2;
                ++n9;
                n23 -= 2;
                ++n10;
            }
            if (n7 < n6) {
                if (n2 % 2 != 0) {
                    byArray[n8 += n2 / 2] = (byte)(Integer.parseInt(new String((char[])object, n6 - 1, 1)) * 10);
                    --n6;
                    --n2;
                } else {
                    byArray[n8 += n2 / 2 - 1] = (byte)Integer.parseInt(new String((char[])object, n6 - 2, 2));
                    n6 -= 2;
                    n2 -= 2;
                }
                ++n10;
                --n8;
            }
            while (n2 > 0) {
                byArray[n8] = (byte)Integer.parseInt(new String((char[])object, n6 - 2, 2));
                --n8;
                n6 -= 2;
                n2 -= 2;
                ++n10;
            }
        }
        if (bl2) {
            n5 = n10;
            n14 = Integer.parseInt(new String((char[])object, n13, 1));
            if (n14 >= 5) {
                int n25 = --n5;
                byArray[n25] = (byte)(byArray[n25] + 1);
                while (byArray[n5] == 100) {
                    if (n5 == 0) {
                        ++n9;
                        byArray[n5] = 1;
                        break;
                    }
                    byArray[n5] = 0;
                    int n26 = --n5;
                    byArray[n26] = (byte)(byArray[n26] + 1);
                }
                for (n4 = n10 - 1; n4 >= 0 && byArray[n4] == 0; --n4) {
                    --n10;
                }
            }
        }
        byte[] byArray2 = new byte[n10 + 1];
        byArray2[0] = (byte)n9;
        System.arraycopy(byArray, 0, byArray2, 1, n10);
        return NUMBER._toLnxFmt(byArray2, bl);
    }

    public static byte[] toBytes(boolean bl) {
        if (bl) {
            return NUMBER.toBytes(1L);
        }
        return NUMBER.toBytes(0L);
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    @Override
    public double doubleValue() {
        return NUMBER.toDouble(this.shareBytes());
    }

    @Override
    public float floatValue() {
        return NUMBER.toFloat(this.shareBytes());
    }

    @Override
    public long longValue() throws SQLException {
        return NUMBER.toLong(this.shareBytes());
    }

    @Override
    public int intValue() throws SQLException {
        return NUMBER.toInt(this.shareBytes());
    }

    public short shortValue() throws SQLException {
        return NUMBER.toShort(this.shareBytes());
    }

    @Override
    public byte byteValue() throws SQLException {
        return NUMBER.toByte(this.shareBytes());
    }

    public BigInteger bigIntegerValue() throws SQLException {
        return NUMBER.toBigInteger(this.shareBytes());
    }

    @Override
    public BigDecimal bigDecimalValue() throws SQLException {
        return NUMBER.toBigDecimal(this.shareBytes());
    }

    @Override
    public String stringValue() {
        return NUMBER.toString(this.shareBytes());
    }

    @Override
    public boolean booleanValue() {
        return NUMBER.toBoolean(this.shareBytes());
    }

    @Override
    public Object toJdbc() throws SQLException {
        try {
            return this.bigDecimalValue();
        }
        catch (SQLException sQLException) {
            return new SQLException(sQLException.getMessage());
        }
    }

    @Override
    public Object makeJdbcArray(int n2) {
        BigDecimal[] bigDecimalArray = new BigDecimal[n2];
        return bigDecimalArray;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.Integer") == 0 || string.compareTo("java.lang.Long") == 0 || string.compareTo("java.lang.Float") == 0 || string.compareTo("java.lang.Double") == 0 || string.compareTo("java.math.BigInteger") == 0 || string.compareTo("java.math.BigDecimal") == 0 || string.compareTo("java.lang.String") == 0 || string.compareTo("java.lang.Boolean") == 0 || string.compareTo("java.lang.Byte") == 0 || string.compareTo("java.lang.Short") == 0;
    }

    public NUMBER abs() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxabs(this.shareBytes()));
    }

    public NUMBER acos() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxacos(this.shareBytes()));
    }

    public NUMBER add(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxadd(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER asin() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxasin(this.shareBytes()));
    }

    public NUMBER atan() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxatan(this.shareBytes()));
    }

    public NUMBER atan2(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxatan2(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER ceil() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxceil(this.shareBytes()));
    }

    public NUMBER cos() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxcos(this.shareBytes()));
    }

    public NUMBER cosh() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxcsh(this.shareBytes()));
    }

    public NUMBER decrement() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxdec(this.shareBytes()));
    }

    public NUMBER div(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxdiv(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER exp() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxexp(this.shareBytes()));
    }

    public NUMBER floatingPointRound(int n2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxfpr(this.shareBytes(), n2));
    }

    public NUMBER floor() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxflo(this.shareBytes()));
    }

    public NUMBER increment() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxinc(this.shareBytes()));
    }

    public NUMBER ln() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxln(this.shareBytes()));
    }

    public NUMBER log(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxlog(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER mod(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxmod(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER mul(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxmul(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER negate() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxneg(this.shareBytes()));
    }

    public NUMBER pow(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxbex(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER pow(int n2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxpow(this.shareBytes(), n2));
    }

    public NUMBER round(int n2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxrou(this.shareBytes(), n2));
    }

    public NUMBER scale(int n2, int n3, boolean[] blArray) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsca(this.shareBytes(), n2, n3, blArray));
    }

    public NUMBER shift(int n2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxshift(this.shareBytes(), n2));
    }

    public NUMBER sin() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsin(this.shareBytes()));
    }

    public NUMBER sinh() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsnh(this.shareBytes()));
    }

    public NUMBER sqroot() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsqr(this.shareBytes()));
    }

    public NUMBER sub(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsub(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER tan() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxtan(this.shareBytes()));
    }

    public NUMBER tanh() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxtnh(this.shareBytes()));
    }

    public NUMBER truncate(int n2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxtru(this.shareBytes(), n2));
    }

    public static NUMBER formattedTextToNumber(String string, String string2, String string3) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxfcn(string, string2, string3));
    }

    public static NUMBER textToPrecisionNumber(String string, boolean bl, int n2, boolean bl2, int n3, String string2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxcpn(string, bl, n2, bl2, n3, string2));
    }

    public String toFormattedText(String string, String string2) throws SQLException {
        return NUMBER._getLnxLib().lnxnfn(this.shareBytes(), string, string2);
    }

    public String toText(int n2, String string) throws SQLException {
        return NUMBER._getLnxLib().lnxnuc(this.shareBytes(), n2, string);
    }

    public int compareTo(NUMBER nUMBER) {
        return NUMBER.compareBytes(this.shareBytes(), nUMBER.shareBytes());
    }

    public boolean isInf() {
        return NUMBER._isInf(this.shareBytes());
    }

    public boolean isNegInf() {
        return NUMBER._isNegInf(this.shareBytes());
    }

    public boolean isPosInf() {
        return NUMBER._isPosInf(this.shareBytes());
    }

    public boolean isInt() {
        return NUMBER._isInt(this.shareBytes());
    }

    public static boolean isValid(byte[] byArray) {
        int n2 = byArray.length;
        if (NUMBER._isPositive(byArray)) {
            if (n2 == 1) {
                return NUMBER._isZero(byArray);
            }
            if (byArray[0] == -1 && byArray[1] == 101) {
                return n2 == 2;
            }
            if (n2 > 21) {
                return false;
            }
            if (byArray[1] < 2 || byArray[n2 - 1] < 2) {
                return false;
            }
            for (int i2 = 1; i2 < n2; ++i2) {
                byte by = byArray[i2];
                if (by >= 1 && by <= 100) continue;
                return false;
            }
            return true;
        }
        if (n2 < 3) {
            return NUMBER._isNegInf(byArray);
        }
        if (n2 > 21) {
            return false;
        }
        if (byArray[n2 - 1] != 102) {
            if (n2 <= 20) {
                return false;
            }
        } else {
            n2 = (byte)(n2 - 1);
        }
        if (byArray[1] > 100 || byArray[n2 - 1] > 100) {
            return false;
        }
        for (int i3 = 1; i3 < n2; ++i3) {
            byte by = byArray[i3];
            if (by >= 2 && by <= 101) continue;
            return false;
        }
        return true;
    }

    public boolean isZero() {
        return NUMBER._isZero(this.shareBytes());
    }

    public static NUMBER e() {
        return new NUMBER(E);
    }

    public static NUMBER ln10() {
        return new NUMBER(LN10);
    }

    public static NUMBER negInf() {
        return new NUMBER(NUMBER._makeNegInf());
    }

    public static NUMBER pi() {
        return new NUMBER(PI);
    }

    public static NUMBER posInf() {
        return new NUMBER(NUMBER._makePosInf());
    }

    public static NUMBER zero() {
        return new NUMBER(NUMBER._makeZero());
    }

    public int sign() {
        if (NUMBER._isZero(this.shareBytes())) {
            return 0;
        }
        return NUMBER._isPositive(this.shareBytes()) ? 1 : -1;
    }

    static boolean _isInf(byte[] byArray) {
        return byArray.length == 2 && byArray[0] == -1 && byArray[1] == 101 || byArray[0] == 0 && byArray.length == 1;
    }

    private static boolean _isInt(byte[] byArray) {
        byte by;
        if (NUMBER._isZero(byArray)) {
            return true;
        }
        if (NUMBER._isInf(byArray)) {
            return false;
        }
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        byte by2 = (byte)(byArray2.length - 1);
        return by2 <= (by = byArray2[0]) + 1;
    }

    static boolean _isNegInf(byte[] byArray) {
        return byArray[0] == 0 && byArray.length == 1;
    }

    static boolean _isPosInf(byte[] byArray) {
        return byArray.length == 2 && byArray[0] == -1 && byArray[1] == 101;
    }

    static boolean _isPositive(byte[] byArray) {
        return (byArray[0] & 0xFFFFFF80) != 0;
    }

    static boolean _isZero(byte[] byArray) {
        return byArray[0] == -128 && byArray.length == 1;
    }

    static byte[] _makePosInf() {
        byte[] byArray = new byte[]{-1, 101};
        return byArray;
    }

    static byte[] _makeNegInf() {
        byte[] byArray = new byte[]{0};
        return byArray;
    }

    static byte[] _makeZero() {
        byte[] byArray = new byte[]{-128};
        return byArray;
    }

    static byte[] _fromLnxFmt(byte[] byArray) {
        byte[] byArray2;
        int n2 = byArray.length;
        if (NUMBER._isPositive(byArray)) {
            byArray2 = new byte[n2];
            byArray2[0] = (byte)((byArray[0] & 0xFFFFFF7F) - 65);
            for (int i2 = 1; i2 < n2; ++i2) {
                byArray2[i2] = (byte)(byArray[i2] - 1);
            }
        } else {
            byArray2 = n2 - 1 == 20 && byArray[n2 - 1] != 102 ? new byte[n2] : new byte[n2 - 1];
            byArray2[0] = (byte)((~byArray[0] & 0xFFFFFF7F) - 65);
            for (int i3 = 1; i3 < byArray2.length; ++i3) {
                byArray2[i3] = (byte)(101 - byArray[i3]);
            }
        }
        return byArray2;
    }

    static byte[] _toLnxFmt(byte[] byArray, boolean bl) {
        byte[] byArray2;
        int n2 = byArray.length;
        if (bl) {
            byArray2 = new byte[n2];
            byArray2[0] = (byte)(byArray[0] + 128 + 64 + 1);
            for (int i2 = 1; i2 < n2; ++i2) {
                byArray2[i2] = (byte)(byArray[i2] + 1);
            }
        } else {
            int n3;
            byArray2 = n2 - 1 < 20 ? new byte[n2 + 1] : new byte[n2];
            byArray2[0] = (byte)(~(byArray[0] + 128 + 64 + 1));
            for (n3 = 1; n3 < n2; ++n3) {
                byArray2[n3] = (byte)(101 - byArray[n3]);
            }
            if (n3 <= 20) {
                byArray2[n3] = 102;
            }
        }
        return byArray2;
    }

    private static LnxLib _getLnxLib() {
        if (_slnxlib == null) {
            try {
                _slnxlib = System.getProperty("oracle.jserver.version") != null ? new LnxLibForServer() : new LnxLibThin();
            }
            catch (SecurityException securityException) {
                _slnxlib = new LnxLibThin();
            }
        }
        return _slnxlib;
    }

    private static LnxLib _getThinLib() {
        if (_thinlib == null) {
            _thinlib = new LnxLibThin();
        }
        return _thinlib;
    }

    private static int _byteToChars(byte by, char[] cArray, int n2) {
        if (by < 0) {
            return 0;
        }
        if (by < 10) {
            cArray[n2] = (char)(48 + by);
            return 1;
        }
        if (by < 100) {
            cArray[n2] = (char)(48 + by / 10);
            cArray[n2 + 1] = (char)(48 + by % 10);
            return 2;
        }
        cArray[n2] = 49;
        cArray[n2 + 1] = (char)(48 + by / 10 - 10);
        cArray[n2 + 2] = (char)(48 + by % 10);
        return 3;
    }

    private static void _byteTo2Chars(byte by, char[] cArray, int n2) {
        if (by < 0) {
            cArray[n2] = 48;
            cArray[n2 + 1] = 48;
        } else if (by < 10) {
            cArray[n2] = 48;
            cArray[n2 + 1] = (char)(48 + by);
        } else if (by < 100) {
            cArray[n2] = (char)(48 + by / 10);
            cArray[n2 + 1] = (char)(48 + by % 10);
        } else {
            cArray[n2] = 48;
            cArray[n2 + 1] = 48;
        }
    }

    private static void _printBytes(byte[] byArray) {
        int n2 = byArray.length;
        System.out.print(n2 + ": ");
        for (int i2 = 0; i2 < n2; ++i2) {
            System.out.print(byArray[i2] + " ");
        }
        System.out.println();
    }

    private byte[] stringToBytes(String string) throws SQLException {
        int n2 = 0;
        if ((string = string.trim()).indexOf(46) >= 0) {
            n2 = string.length() - 1 - string.indexOf(46);
        }
        return NUMBER.toBytes(string, n2);
    }

    static {
        _thinlib = null;
        DBL_MAX = 40;
        INT_MAX = 15;
        FLOAT_MAX_INT = 2.1474836E9f;
        FLOAT_MIN_INT = -2.1474836E9f;
        DOUBLE_MAX_INT = 2.147483647E9;
        DOUBLE_MIN_INT = -2.147483648E9;
        DOUBLE_MAX_INT_2 = 2.147483649E9;
        DOUBLE_MIN_INT_2 = -2.147483649E9;
        drvType = null;
        try {
            drvType = System.getProperty("oracle.jserver.version");
        }
        catch (SecurityException securityException) {
            drvType = null;
        }
        LANGID = "AMERICAN";
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    }
}

