package mx.com.amx.mx.dda.crn;

import java.util.Properties;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import mx.com.amx.mx.dda.crn.bo.DDACargaAddOnsBO;
import org.apache.log4j.Logger;


public class DDACargaAddOns implements ApplicationContextAware
{
	private ApplicationContext context;
	private final String ARCHIVO_PROPIEDADES 	= "/general.properties";
	private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	Properties env 	= 	new Properties();
	private DDACargaAddOnsBO bo;
	
	public DDACargaAddOns()
	{
		super();
		try
		{
			env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
		}
		catch(Exception e)
		{
			LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );
		}
	}
	
	public void ejecutaProceso()
	{
		
		LOG.info("  ");
		LOG.info("<< :::::::::::::::: Inicia Proceso Carga Add On's DDA :::::::::::::::: >>");
		try
		{
			
			//-- 1. Verifica que no se este ejecutando ya un proceso de Notificacion
			LOG.info("    [INI]. Paso unico ini.- Ejecucion de SP carga.");
			boolean boEjecutandoseProceso = bo.existeProcesoNotificacionEjecutandose();
			LOG.info("    [INI]. Paso unico fin.");
			
			
		}
		catch (Exception e)
		{
			LOG.error("Ocurrio un error en ejecutaProceso::Carga Add On's: " + e.getMessage());
		}
		
		LOG.info("<< :::::::::::::::: Finaliza Proceso Carga Add On's DDA :::::::::::::::: >>");
		LOG.info("  ");
	}
	
	
	
	@Override
	public void setApplicationContext(ApplicationContext arg0) 	throws BeansException 
	{
		LOG.info("Entering to the application Context...");
		this.context = context;
	}

	public DDACargaAddOnsBO getBo() {
		return bo;
	}

	public void setBo(DDACargaAddOnsBO bo) {
		this.bo = bo;
	}
	

}


