/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.ObjectMorpher;
import net.sf.ezmorph.object.IdentityObjectMorpher;

public class MorpherRegistry
implements Serializable {
    private static final long serialVersionUID = -3894767123320768419L;
    private Map morphers = new HashMap();
    static /* synthetic */ Class class$0;

    public void clear() {
        this.morphers.clear();
    }

    public void clear(Class type) {
        List registered = (List)this.morphers.get(type);
        if (registered != null) {
            this.morphers.remove(type);
        }
    }

    public void deregisterMorpher(Morpher morpher) {
        List registered = (List)this.morphers.get(morpher.morphsTo());
        if (registered != null && !registered.isEmpty()) {
            registered.remove(morpher);
            if (registered.isEmpty()) {
                this.morphers.remove(morpher.morphsTo());
            }
        }
    }

    public Morpher getMorpherFor(Class clazz) {
        List registered = (List)this.morphers.get(clazz);
        if (registered == null || registered.isEmpty()) {
            return IdentityObjectMorpher.getInstance();
        }
        return (Morpher)registered.get(0);
    }

    public Morpher[] getMorphersFor(Class clazz) {
        List registered = (List)this.morphers.get(clazz);
        if (registered == null || registered.isEmpty()) {
            return new Morpher[]{IdentityObjectMorpher.getInstance()};
        }
        Morpher[] morphs = new Morpher[registered.size()];
        int k = 0;
        Iterator i = registered.iterator();
        while (i.hasNext()) {
            morphs[k++] = (Morpher)i.next();
        }
        return morphs;
    }

    public Object morph(Class target, Object value) {
        if (value == null) {
            Morpher morpher = this.getMorpherFor(target);
            if (morpher instanceof ObjectMorpher) {
                return ((ObjectMorpher)morpher).morph(value);
            }
            try {
                Class<?> clazz = morpher.getClass();
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Method morphMethod = clazz.getDeclaredMethod("morph", classArray);
                return morphMethod.invoke((Object)morpher, value);
            }
            catch (Exception e) {
                throw new MorphException(e);
            }
        }
        Morpher[] morphers = this.getMorphersFor(target);
        int i = 0;
        while (i < morphers.length) {
            Morpher morpher = morphers[i];
            if (morpher.supports(value.getClass())) {
                if (morpher instanceof ObjectMorpher) {
                    return ((ObjectMorpher)morpher).morph(value);
                }
                try {
                    Class<?> clazz = morpher.getClass();
                    Class[] classArray = new Class[1];
                    Class<?> clazz3 = class$0;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$0 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz3;
                    Method morphMethod = clazz.getDeclaredMethod("morph", classArray);
                    return morphMethod.invoke((Object)morpher, value);
                }
                catch (Exception e) {
                    throw new MorphException(e);
                }
            }
            ++i;
        }
        return value;
    }

    public void registerMorpher(Morpher morpher) {
        this.registerMorpher(morpher, false);
    }

    public void registerMorpher(Morpher morpher, boolean override) {
        ArrayList<Morpher> registered = (ArrayList<Morpher>)this.morphers.get(morpher.morphsTo());
        if (override || registered == null) {
            registered = new ArrayList<Morpher>();
            this.morphers.put(morpher.morphsTo(), registered);
        }
        if (!registered.contains(morpher)) {
            registered.add(morpher);
        }
    }
}

