/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.beans.PropertyEditor;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceEditor;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.ServletContextResourceLoader;
import org.springframework.web.context.support.StandardServletEnvironment;

public abstract class HttpServletBean
extends HttpServlet
implements EnvironmentAware {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Set<String> requiredProperties = new HashSet<String>();
    private Environment environment = new StandardServletEnvironment();

    protected final void addRequiredProperty(String property) {
        this.requiredProperties.add(property);
    }

    public final void init() throws ServletException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Initializing servlet '" + this.getServletName() + "'"));
        }
        try {
            ServletConfigPropertyValues pvs = new ServletConfigPropertyValues(this.getServletConfig(), this.requiredProperties);
            BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)((Object)this));
            ServletContextResourceLoader resourceLoader = new ServletContextResourceLoader(this.getServletContext());
            bw.registerCustomEditor(Resource.class, (PropertyEditor)new ResourceEditor((ResourceLoader)resourceLoader, (PropertyResolver)this.environment));
            this.initBeanWrapper(bw);
            bw.setPropertyValues((PropertyValues)pvs, true);
        }
        catch (BeansException ex) {
            this.logger.error((Object)("Failed to set bean properties on servlet '" + this.getServletName() + "'"), (Throwable)ex);
            throw ex;
        }
        this.initServletBean();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Servlet '" + this.getServletName() + "' configured successfully"));
        }
    }

    protected void initBeanWrapper(BeanWrapper bw) throws BeansException {
    }

    public final String getServletName() {
        return this.getServletConfig() != null ? this.getServletConfig().getServletName() : null;
    }

    public final ServletContext getServletContext() {
        return this.getServletConfig() != null ? this.getServletConfig().getServletContext() : null;
    }

    protected void initServletBean() throws ServletException {
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServletConfigPropertyValues
    extends MutablePropertyValues {
        public ServletConfigPropertyValues(ServletConfig config, Set<String> requiredProperties) throws ServletException {
            HashSet<String> missingProps = requiredProperties != null && !requiredProperties.isEmpty() ? new HashSet<String>(requiredProperties) : null;
            Enumeration en = config.getInitParameterNames();
            while (en.hasMoreElements()) {
                String property = (String)en.nextElement();
                String value = config.getInitParameter(property);
                this.addPropertyValue(new PropertyValue(property, (Object)value));
                if (missingProps == null) continue;
                missingProps.remove(property);
            }
            if (missingProps != null && missingProps.size() > 0) {
                throw new ServletException("Initialization from ServletConfig for servlet '" + config.getServletName() + "' failed; the following required properties were missing: " + StringUtils.collectionToDelimitedString(missingProps, (String)", "));
            }
        }
    }
}

