/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.oxm.XmlMappingException;
import org.springframework.util.Assert;
import org.springframework.xml.transform.TraxUtils;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class AbstractMarshaller
implements Marshaller,
Unmarshaller {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private DocumentBuilderFactory documentBuilderFactory;

    public final void marshal(Object graph, Result result) throws XmlMappingException, IOException {
        if (result instanceof DOMResult) {
            this.marshalDomResult(graph, (DOMResult)result);
        } else if (TraxUtils.isStaxResult(result)) {
            this.marshalStaxResult(graph, result);
        } else if (result instanceof SAXResult) {
            this.marshalSaxResult(graph, (SAXResult)result);
        } else if (result instanceof StreamResult) {
            this.marshalStreamResult(graph, (StreamResult)result);
        } else {
            throw new IllegalArgumentException("Unknown Result type: " + result.getClass());
        }
    }

    public final Object unmarshal(Source source) throws XmlMappingException, IOException {
        if (source instanceof DOMSource) {
            return this.unmarshalDomSource((DOMSource)source);
        }
        if (TraxUtils.isStaxSource(source)) {
            return this.unmarshalStaxSource(source);
        }
        if (source instanceof SAXSource) {
            return this.unmarshalSaxSource((SAXSource)source);
        }
        if (source instanceof StreamSource) {
            return this.unmarshalStreamSource((StreamSource)source);
        }
        throw new IllegalArgumentException("Unknown Source type: " + source.getClass());
    }

    protected DocumentBuilder createDocumentBuilder(DocumentBuilderFactory factory) throws ParserConfigurationException {
        return factory.newDocumentBuilder();
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        return factory;
    }

    protected XMLReader createXmlReader() throws SAXException {
        return XMLReaderFactory.createXMLReader();
    }

    protected void marshalDomResult(Object graph, DOMResult domResult) throws XmlMappingException {
        Assert.notNull((Object)domResult.getNode(), (String)"DOMResult does not contain Node");
        this.marshalDomNode(graph, domResult.getNode());
    }

    protected void marshalStaxResult(Object graph, Result staxResult) throws XmlMappingException {
        XMLStreamWriter streamWriter = TraxUtils.getXMLStreamWriter(staxResult);
        if (streamWriter != null) {
            this.marshalXmlStreamWriter(graph, streamWriter);
        } else {
            XMLEventWriter eventWriter = TraxUtils.getXMLEventWriter(staxResult);
            if (eventWriter != null) {
                this.marshalXmlEventWriter(graph, eventWriter);
            } else {
                throw new IllegalArgumentException("StaxResult contains neither XMLStreamWriter nor XMLEventConsumer");
            }
        }
    }

    protected void marshalSaxResult(Object graph, SAXResult saxResult) throws XmlMappingException {
        ContentHandler contentHandler = saxResult.getHandler();
        Assert.notNull((Object)contentHandler, (String)"ContentHandler not set on SAXResult");
        LexicalHandler lexicalHandler = saxResult.getLexicalHandler();
        this.marshalSaxHandlers(graph, contentHandler, lexicalHandler);
    }

    protected void marshalStreamResult(Object graph, StreamResult streamResult) throws XmlMappingException, IOException {
        if (streamResult.getOutputStream() != null) {
            this.marshalOutputStream(graph, streamResult.getOutputStream());
        } else if (streamResult.getWriter() != null) {
            this.marshalWriter(graph, streamResult.getWriter());
        } else {
            throw new IllegalArgumentException("StreamResult contains neither OutputStream nor Writer");
        }
    }

    protected Object unmarshalDomSource(DOMSource domSource) throws XmlMappingException {
        if (domSource.getNode() == null) {
            try {
                if (this.documentBuilderFactory == null) {
                    this.documentBuilderFactory = this.createDocumentBuilderFactory();
                }
                DocumentBuilder documentBuilder = this.createDocumentBuilder(this.documentBuilderFactory);
                domSource.setNode(documentBuilder.newDocument());
            }
            catch (ParserConfigurationException ex) {
                throw new UnmarshallingFailureException("Could not create document placeholder for DOMSource: " + ex.getMessage(), ex);
            }
        }
        return this.unmarshalDomNode(domSource.getNode());
    }

    protected Object unmarshalStaxSource(Source staxSource) throws XmlMappingException {
        XMLStreamReader streamReader = TraxUtils.getXMLStreamReader(staxSource);
        if (streamReader != null) {
            return this.unmarshalXmlStreamReader(streamReader);
        }
        XMLEventReader eventReader = TraxUtils.getXMLEventReader(staxSource);
        if (eventReader != null) {
            return this.unmarshalXmlEventReader(eventReader);
        }
        throw new IllegalArgumentException("StaxSource contains neither XMLStreamReader nor XMLEventReader");
    }

    protected Object unmarshalSaxSource(SAXSource saxSource) throws XmlMappingException, IOException {
        if (saxSource.getXMLReader() == null) {
            try {
                saxSource.setXMLReader(this.createXmlReader());
            }
            catch (SAXException ex) {
                throw new UnmarshallingFailureException("Could not create XMLReader for SAXSource: " + ex.getMessage(), ex);
            }
        }
        if (saxSource.getInputSource() == null) {
            saxSource.setInputSource(new InputSource());
        }
        return this.unmarshalSaxReader(saxSource.getXMLReader(), saxSource.getInputSource());
    }

    protected Object unmarshalStreamSource(StreamSource streamSource) throws XmlMappingException, IOException {
        if (streamSource.getInputStream() != null) {
            return this.unmarshalInputStream(streamSource.getInputStream());
        }
        if (streamSource.getReader() != null) {
            return this.unmarshalReader(streamSource.getReader());
        }
        throw new IllegalArgumentException("StreamSource contains neither InputStream nor Reader");
    }

    protected abstract void marshalDomNode(Object var1, Node var2) throws XmlMappingException;

    protected abstract void marshalXmlEventWriter(Object var1, XMLEventWriter var2) throws XmlMappingException;

    protected abstract void marshalXmlStreamWriter(Object var1, XMLStreamWriter var2) throws XmlMappingException;

    protected abstract void marshalOutputStream(Object var1, OutputStream var2) throws XmlMappingException, IOException;

    protected abstract void marshalSaxHandlers(Object var1, ContentHandler var2, LexicalHandler var3) throws XmlMappingException;

    protected abstract void marshalWriter(Object var1, Writer var2) throws XmlMappingException, IOException;

    protected abstract Object unmarshalDomNode(Node var1) throws XmlMappingException;

    protected abstract Object unmarshalXmlEventReader(XMLEventReader var1) throws XmlMappingException;

    protected abstract Object unmarshalXmlStreamReader(XMLStreamReader var1) throws XmlMappingException;

    protected abstract Object unmarshalInputStream(InputStream var1) throws XmlMappingException, IOException;

    protected abstract Object unmarshalReader(Reader var1) throws XmlMappingException, IOException;

    protected abstract Object unmarshalSaxReader(XMLReader var1, InputSource var2) throws XmlMappingException, IOException;
}

