package mx.com.amx.mx.dda.crn.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import mx.com.amx.mx.dda.crn.dto.ContratoTituloDTO;
import mx.com.amx.mx.dda.crn.dto.DatosCntTituloExhibicionDTO;
import mx.com.amx.mx.dda.crn.dto.ItemActivoFijoDTO;
import mx.com.amx.mx.dda.crn.dto.ParametroDTO;


@Component
@Qualifier("ddaexhibicionDAO")
public class DDACargaAddOnsDAO implements IDDAExhibicionDAO
{
                private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
                private final String ARCHIVO_PROPIEDADES       = "/general.properties";
                Properties env =             new Properties();
                private JdbcTemplate jdbcTemplate;
                
                private String AMBIENTE;
                private String VALOR_REFERENCIA;
                private String PUEDE_EJECUTAR;
                private String NOTIFICACION_INICIADO;
                private String MODULO;
                private String ESTATUS_VIGENTE;
                private String SUBNUMERO;
                private String CENTRO_COSTO;
                
                
                public DDACargaAddOnsDAO() 
                { 
                               super();
                               try
                               {
                                               env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
                                               AMBIENTE = env.getProperty("ambiente");
                                               CENTRO_COSTO = env.getProperty(AMBIENTE+".centro.costo");
                                               VALOR_REFERENCIA=env.getProperty("valor.referencia");
                                               PUEDE_EJECUTAR=env.getProperty("puede.ejecutar");
                                               NOTIFICACION_INICIADO=env.getProperty("notificacion.iniciado");
                                               MODULO=env.getProperty("modulo");
                                               ESTATUS_VIGENTE = env.getProperty("estatus.vigente");
                                               SUBNUMERO = env.getProperty("subnumero");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );
                               }
                
                }
                
                @Override
                public boolean verificaEjecutandoseProcesoNotificacion() throws Exception 
                {
                               boolean lboEjecutando = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                                int lnuRowsUpdate = 0;
                               
                               try
                               {
                                               //--Debug
                                             sbD.append("call DDA_CARGA_ADD_ONS");
                                               LOG.debug(">Sql_D [DDA_CARGA_ADD_ONS]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("call DDA_CARGA_ADD_ONS()");
                                                                                              
                                               final String lstSQL = sb.toString();
                                                                                               
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               if(lnuRowsUpdate >= 0)
                                                             LOG.debug(">Sql_D [DDA_CARGA_ADD_ONS]:     OK " );
                                              
                                               
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::verificaEjecutandoseProcesoNotificacion]: No se encontraron registros coincidentes con la clave especificada. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes con la clave especificada");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::verificaEjecutandoseProcesoNotificacion]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return lboEjecutando;
                }
                
                @Override
                public boolean puedeIniciarProcesoNotificacion() throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                             
                               return resultado;
                }
                
                @Override
                public boolean updateEjecutandoseProcesoNotificacion(String pstValor) throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                              
                               
                               return resultado;
                }
                
                @Override
                public List<ParametroDTO> getValorDiaNotificacion() throws Exception 
                {
                               List<ParametroDTO> lobResultado = new ArrayList<ParametroDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                             
                               
                               return lobResultado;
                }
                
                @Override
                public List<DatosCntTituloExhibicionDTO> obtenerTitulosRecienExhibidos(String pstFechaReferencia) throws Exception 
                {
                               //List<ContratoTituloDTO> lobResultado = new ArrayList<ContratoTituloDTO>();
                               List<DatosCntTituloExhibicionDTO> lobResultado = new ArrayList<DatosCntTituloExhibicionDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                             
                               return lobResultado;
                }
                
                @Override
                public boolean actualizaFechaNotificacion(ContratoTituloDTO dto) throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               
                               return resultado;
                }
                
                @Override
                public boolean insertarRegistroSubnum(String pstIdTituloCntOrig) throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               
                               
                               return resultado;
                }
                
                @Override
                public List<ItemActivoFijoDTO> obtenerTitulosSinIdSAP_RecienExhibidos(String pstFechaReferencia) throws Exception 
                {
                               List<ItemActivoFijoDTO> lobResultado = new ArrayList<ItemActivoFijoDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                              
                               
                               return lobResultado;
                               
                }
                
                @Override
                public boolean actualizaIdSAPCntTitulo(ContratoTituloDTO dto) throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                              
                               return resultado;
                }

                public JdbcTemplate getJdbcTemplate() {
                               return jdbcTemplate;
                }

                public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
                               this.jdbcTemplate = jdbcTemplate;
                }

                @Override
                public boolean ejecutarSPAmortizacionReal() throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                              
                               
                               return resultado;
                }

}
