package mx.com.amx.mx.dda.crn.restClient;

import org.springframework.http.MediaType;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class DDARestClient {

	private RestTemplate template;
	private String uri;

	public DDARestClient(String uri) {

		try {
			HttpComponentsClientHttpRequestFactory client = new HttpComponentsClientHttpRequestFactory();
			// client.setConnectTimeout(1200000);
			client.setReadTimeout(60000 * 10);
			client.setConnectTimeout(60000 * 10);
			template = new RestTemplate(client);

			template.getMessageConverters().add(new MappingJacksonHttpMessageConverter());
			template.getMessageConverters().add(new StringHttpMessageConverter());
			template.getInterceptors().add(new HeaderRequestInterceptor("Accept", MediaType.APPLICATION_JSON_VALUE));
			template.getInterceptors()
					.add(new HeaderRequestInterceptor("Content-Type", MediaType.APPLICATION_JSON_VALUE));
			this.uri = uri;
		} catch (Exception e) {
			// TODO: handle exception

			System.out.println("error: " + e.getMessage());

		}

	}

	public <T> T get(Class<T> responseType) {
		HttpComponentsClientHttpRequestFactory client = new HttpComponentsClientHttpRequestFactory();
		client.setReadTimeout(60000 * 10);
		client.setConnectTimeout(60000 * 10);
		template = new RestTemplate(client);

		template.getMessageConverters().add(new MappingJacksonHttpMessageConverter());
		template.getMessageConverters().add(new StringHttpMessageConverter());
		template.getInterceptors().add(new HeaderRequestInterceptor("Accept", MediaType.APPLICATION_JSON_VALUE));
		template.getInterceptors().add(new HeaderRequestInterceptor("Content-Type", MediaType.APPLICATION_JSON_VALUE));

		T r = template.postForObject(uri, "", responseType);

		client.destroy();
		return r;
	}

	public <T> T get(Object request, Class<T> responseType) {
		HttpComponentsClientHttpRequestFactory client = new HttpComponentsClientHttpRequestFactory();
		client.setReadTimeout(60000 * 10);
		client.setConnectTimeout(60000 * 10);
		template = new RestTemplate(client);

		template.getMessageConverters().add(new MappingJacksonHttpMessageConverter());
		template.getMessageConverters().add(new StringHttpMessageConverter());
		template.getInterceptors().add(new HeaderRequestInterceptor("Accept", MediaType.APPLICATION_JSON_VALUE));
		template.getInterceptors().add(new HeaderRequestInterceptor("Content-Type", MediaType.APPLICATION_JSON_VALUE));
		T r = template.postForObject(uri, request, responseType);

		client.destroy();
		return r;
	}
	
	public <T> T get(String request, Class<T> responseType) {
		HttpComponentsClientHttpRequestFactory client = new HttpComponentsClientHttpRequestFactory();
		client.setReadTimeout(60000 * 10);
		client.setConnectTimeout(60000 * 10);
		template = new RestTemplate(client);

		template.getMessageConverters().add(new MappingJacksonHttpMessageConverter());
		template.getMessageConverters().add(new StringHttpMessageConverter());
		template.getInterceptors().add(new HeaderRequestInterceptor("Accept", MediaType.APPLICATION_JSON_VALUE));
		//template.getInterceptors().add(new HeaderRequestInterceptor("Content-Type", MediaType.APPLICATION_JSON_VALUE));
		System.out.println("URL: " + uri.concat(request));
		T r = template.getForObject(uri.concat(request), responseType);

		client.destroy();
		return r;
	}

	public void get(Object request) {
		HttpComponentsClientHttpRequestFactory client = new HttpComponentsClientHttpRequestFactory();
		client.setReadTimeout(60000 * 5);
		client.setConnectTimeout(60000 * 5);
		template = new RestTemplate(client);

		template.getMessageConverters().add(new MappingJacksonHttpMessageConverter());
		template.getMessageConverters().add(new StringHttpMessageConverter());
		template.getInterceptors().add(new HeaderRequestInterceptor("Accept", MediaType.APPLICATION_JSON_VALUE));
		template.getInterceptors().add(new HeaderRequestInterceptor("Content-Type", MediaType.APPLICATION_JSON_VALUE));
		template.postForObject(uri, request, Void.class);

		client.destroy();
	}

	public String getUri() {
		return uri;
	}

}
