/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package mx.com.amx.mx.dda.crn.restClient;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;

/**
 *
 * @author jfmj_
 */
public class DDARestClientFactory {
    private Map<String, String> services;
    private Map<String, DDARestClient> clients;

    @PostConstruct
    private void init()
    {
            clients = new HashMap<String, DDARestClient>();
            for(Map.Entry<String, String> entry:  services.entrySet())
            {
                    String uri = entry.getValue();
                    System.out.println("No existe el servicio: " + uri);
                    DDARestClient rc = new DDARestClient(uri);
                    clients.put(entry.getKey(), rc);
            }
    }

    public DDARestClient getClient(String service) {
            DDARestClient client = clients.get(service);
            if (client == null) {
                    throw new IllegalArgumentException("No existe el servicio: " + service);
            }
            return client;
    }

    public void setServices(Map<String, String> services) {
            this.services = services;
    }
}
