package mx.com.amx.mx.dda.crn;

import java.util.Properties;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import mx.com.amx.mx.dda.crn.bo.DDACargaTransacVisualBO;
import org.apache.log4j.Logger;

public class DDACargaTransacVisual implements ApplicationContextAware {

    private ApplicationContext context;
    private final String ARCHIVO_PROPIEDADES = "/general.properties";
    private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
    Properties env = new Properties();
    private DDACargaTransacVisualBO bo;

    public DDACargaTransacVisual() {
        super();
        try {
            env.load(this.getClass().getResourceAsStream(ARCHIVO_PROPIEDADES));
        } catch (Exception e) {
            LOG.error(">Constructor[" + this.getClass().getSimpleName() + "] Ocurrio un error : " + e.getMessage());
        }
    }

    public void ejecutaProceso() {

        LOG.info("  ");
        LOG.info("<< :::::::::::::::: Inicia Proceso Carga Add On's DDA :::::::::::::::: >>");
        System.out.println("Ejecutando proceso");
        try {

            //-- 1. Verifica que no se este ejecutando ya un proceso de Notificacion
            LOG.info("    [INI]. Paso unico ini.- Ejecucion de SP carga.");
            LOG.info("Recuperando Transacciones");
            bo.recuperarTransacciones();
            LOG.info("Cargando Transacciones");
            //bo.cargarTransacciones();
            LOG.info("Recuperando Visualizaciones");
            bo.recuperarVisualizaciones();
            LOG.info("Cargando Visualizaciones");
            bo.cargarVisualizaciones();

            LOG.info("    [INI]. Paso unico fin.");

        } catch (Exception e) {
            LOG.error("Ocurrio un error en ejecutaProceso::Carga Add On's: " + e.getMessage());
        }

        LOG.info("<< :::::::::::::::: Finaliza Proceso Carga Add On's DDA :::::::::::::::: >>");
        LOG.info("  ");
    }

    @Override
    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        LOG.info("Entering to the application Context...");
        this.context = context;
    }

    public DDACargaTransacVisualBO getBo() {
        return bo;
    }

    public void setBo(DDACargaTransacVisualBO bo) {
        this.bo = bo;
    }

}
