/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.AbstractDescriptor;
import org.springframework.core.convert.BeanPropertyDescriptor;
import org.springframework.core.convert.ClassDescriptor;
import org.springframework.core.convert.FieldDescriptor;
import org.springframework.core.convert.ParameterDescriptor;
import org.springframework.core.convert.Property;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDescriptor {
    static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private static final Map<Class<?>, TypeDescriptor> typeDescriptorCache = new HashMap();
    private final Class<?> type;
    private final TypeDescriptor elementTypeDescriptor;
    private final TypeDescriptor mapKeyTypeDescriptor;
    private final TypeDescriptor mapValueTypeDescriptor;
    private final Annotation[] annotations;

    static {
        typeDescriptorCache.put(Boolean.TYPE, new TypeDescriptor(Boolean.TYPE));
        typeDescriptorCache.put(Boolean.class, new TypeDescriptor(Boolean.class));
        typeDescriptorCache.put(Byte.TYPE, new TypeDescriptor(Byte.TYPE));
        typeDescriptorCache.put(Byte.class, new TypeDescriptor(Byte.class));
        typeDescriptorCache.put(Character.TYPE, new TypeDescriptor(Character.TYPE));
        typeDescriptorCache.put(Character.class, new TypeDescriptor(Character.class));
        typeDescriptorCache.put(Short.TYPE, new TypeDescriptor(Short.TYPE));
        typeDescriptorCache.put(Short.class, new TypeDescriptor(Short.class));
        typeDescriptorCache.put(Integer.TYPE, new TypeDescriptor(Integer.TYPE));
        typeDescriptorCache.put(Integer.class, new TypeDescriptor(Integer.class));
        typeDescriptorCache.put(Long.TYPE, new TypeDescriptor(Long.TYPE));
        typeDescriptorCache.put(Long.class, new TypeDescriptor(Long.class));
        typeDescriptorCache.put(Float.TYPE, new TypeDescriptor(Float.TYPE));
        typeDescriptorCache.put(Float.class, new TypeDescriptor(Float.class));
        typeDescriptorCache.put(Double.TYPE, new TypeDescriptor(Double.TYPE));
        typeDescriptorCache.put(Double.class, new TypeDescriptor(Double.class));
        typeDescriptorCache.put(String.class, new TypeDescriptor(String.class));
    }

    public TypeDescriptor(MethodParameter methodParameter) {
        this(new ParameterDescriptor(methodParameter));
    }

    public TypeDescriptor(Field field) {
        this(new FieldDescriptor(field));
    }

    public TypeDescriptor(Property property) {
        this(new BeanPropertyDescriptor(property));
    }

    public static TypeDescriptor valueOf(Class<?> type) {
        TypeDescriptor desc = typeDescriptorCache.get(type);
        return desc != null ? desc : new TypeDescriptor(type);
    }

    public static TypeDescriptor collection(Class<?> collectionType, TypeDescriptor elementTypeDescriptor) {
        if (!Collection.class.isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException("collectionType must be a java.util.Collection");
        }
        return new TypeDescriptor(collectionType, elementTypeDescriptor);
    }

    public static TypeDescriptor map(Class<?> mapType, TypeDescriptor keyTypeDescriptor, TypeDescriptor valueTypeDescriptor) {
        if (!Map.class.isAssignableFrom(mapType)) {
            throw new IllegalArgumentException("mapType must be a java.util.Map");
        }
        return new TypeDescriptor(mapType, keyTypeDescriptor, valueTypeDescriptor);
    }

    public static TypeDescriptor nested(MethodParameter methodParameter, int nestingLevel) {
        if (methodParameter.getNestingLevel() != 1) {
            throw new IllegalArgumentException("methodParameter nesting level must be 1: use the nestingLevel parameter to specify the desired nestingLevel for nested type traversal");
        }
        return TypeDescriptor.nested(new ParameterDescriptor(methodParameter), nestingLevel);
    }

    public static TypeDescriptor nested(Field field, int nestingLevel) {
        return TypeDescriptor.nested(new FieldDescriptor(field), nestingLevel);
    }

    public static TypeDescriptor nested(Property property, int nestingLevel) {
        return TypeDescriptor.nested(new BeanPropertyDescriptor(property), nestingLevel);
    }

    public static TypeDescriptor forObject(Object source) {
        return source != null ? TypeDescriptor.valueOf(source.getClass()) : null;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getObjectType() {
        return ClassUtils.resolvePrimitiveIfNecessary(this.getType());
    }

    public TypeDescriptor narrow(Object value) {
        if (value == null) {
            return this;
        }
        return new TypeDescriptor(value.getClass(), this.elementTypeDescriptor, this.mapKeyTypeDescriptor, this.mapValueTypeDescriptor, this.annotations);
    }

    public String getName() {
        return ClassUtils.getQualifiedName(this.getType());
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public Annotation getAnnotation(Class<? extends Annotation> annotationType) {
        Annotation[] annotationArray = this.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().equals(annotationType)) {
                return annotation;
            }
            ++n2;
        }
        return null;
    }

    public boolean isAssignableTo(TypeDescriptor typeDescriptor) {
        boolean typesAssignable = typeDescriptor.getObjectType().isAssignableFrom(this.getObjectType());
        if (!typesAssignable) {
            return false;
        }
        if (this.isArray() && typeDescriptor.isArray()) {
            return this.getElementTypeDescriptor().isAssignableTo(typeDescriptor.getElementTypeDescriptor());
        }
        if (this.isCollection() && typeDescriptor.isCollection()) {
            return this.isNestedAssignable(this.getElementTypeDescriptor(), typeDescriptor.getElementTypeDescriptor());
        }
        if (this.isMap() && typeDescriptor.isMap()) {
            return this.isNestedAssignable(this.getMapKeyTypeDescriptor(), typeDescriptor.getMapKeyTypeDescriptor()) && this.isNestedAssignable(this.getMapValueTypeDescriptor(), typeDescriptor.getMapValueTypeDescriptor());
        }
        return true;
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.getType());
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public TypeDescriptor getElementTypeDescriptor() {
        this.assertCollectionOrArray();
        return this.elementTypeDescriptor;
    }

    public TypeDescriptor elementTypeDescriptor(Object element) {
        return this.narrow(element, this.getElementTypeDescriptor());
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    public TypeDescriptor getMapKeyTypeDescriptor() {
        this.assertMap();
        return this.mapKeyTypeDescriptor;
    }

    public TypeDescriptor getMapKeyTypeDescriptor(Object mapKey) {
        return this.narrow(mapKey, this.getMapKeyTypeDescriptor());
    }

    public TypeDescriptor getMapValueTypeDescriptor() {
        this.assertMap();
        return this.mapValueTypeDescriptor;
    }

    public TypeDescriptor getMapValueTypeDescriptor(Object mapValue) {
        return this.narrow(mapValue, this.getMapValueTypeDescriptor());
    }

    @Deprecated
    public Class<?> getElementType() {
        return this.getElementTypeDescriptor().getType();
    }

    @Deprecated
    public Class<?> getMapKeyType() {
        return this.getMapKeyTypeDescriptor().getType();
    }

    @Deprecated
    public Class<?> getMapValueType() {
        return this.getMapValueTypeDescriptor().getType();
    }

    TypeDescriptor(AbstractDescriptor descriptor) {
        this.type = descriptor.getType();
        this.elementTypeDescriptor = descriptor.getElementTypeDescriptor();
        this.mapKeyTypeDescriptor = descriptor.getMapKeyTypeDescriptor();
        this.mapValueTypeDescriptor = descriptor.getMapValueTypeDescriptor();
        this.annotations = descriptor.getAnnotations();
    }

    static Annotation[] nullSafeAnnotations(Annotation[] annotations) {
        return annotations != null ? annotations : EMPTY_ANNOTATION_ARRAY;
    }

    private TypeDescriptor(Class<?> type) {
        this(new ClassDescriptor(type));
    }

    private TypeDescriptor(Class<?> collectionType, TypeDescriptor elementTypeDescriptor) {
        this(collectionType, elementTypeDescriptor, null, null, EMPTY_ANNOTATION_ARRAY);
    }

    private TypeDescriptor(Class<?> mapType, TypeDescriptor keyTypeDescriptor, TypeDescriptor valueTypeDescriptor) {
        this(mapType, null, keyTypeDescriptor, valueTypeDescriptor, EMPTY_ANNOTATION_ARRAY);
    }

    private TypeDescriptor(Class<?> type, TypeDescriptor elementTypeDescriptor, TypeDescriptor mapKeyTypeDescriptor, TypeDescriptor mapValueTypeDescriptor, Annotation[] annotations) {
        this.type = type;
        this.elementTypeDescriptor = elementTypeDescriptor;
        this.mapKeyTypeDescriptor = mapKeyTypeDescriptor;
        this.mapValueTypeDescriptor = mapValueTypeDescriptor;
        this.annotations = annotations;
    }

    private static TypeDescriptor nested(AbstractDescriptor descriptor, int nestingLevel) {
        int i = 0;
        while (i < nestingLevel) {
            if ((descriptor = descriptor.nested()) == null) {
                return null;
            }
            ++i;
        }
        return new TypeDescriptor(descriptor);
    }

    private void assertCollectionOrArray() {
        if (!this.isCollection() && !this.isArray()) {
            throw new IllegalStateException("Not a java.util.Collection or Array");
        }
    }

    private void assertMap() {
        if (!this.isMap()) {
            throw new IllegalStateException("Not a java.util.Map");
        }
    }

    private TypeDescriptor narrow(Object value, TypeDescriptor typeDescriptor) {
        if (typeDescriptor != null) {
            return typeDescriptor.narrow(value);
        }
        return value != null ? new TypeDescriptor(value.getClass(), null, null, null, this.annotations) : null;
    }

    private boolean isNestedAssignable(TypeDescriptor nestedTypeDescriptor, TypeDescriptor otherNestedTypeDescriptor) {
        if (nestedTypeDescriptor == null || otherNestedTypeDescriptor == null) {
            return true;
        }
        return nestedTypeDescriptor.isAssignableTo(otherNestedTypeDescriptor);
    }

    private String wildcard(TypeDescriptor typeDescriptor) {
        return typeDescriptor != null ? typeDescriptor.toString() : "?";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeDescriptor)) {
            return false;
        }
        TypeDescriptor other = (TypeDescriptor)obj;
        if (!ObjectUtils.nullSafeEquals(this.getType(), other.getType())) {
            return false;
        }
        Annotation[] annotations = this.getAnnotations();
        if (annotations.length != other.getAnnotations().length) {
            return false;
        }
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            if (other.getAnnotation(ann.annotationType()) == null) {
                return false;
            }
            ++n2;
        }
        if (this.isCollection() || this.isArray()) {
            return ObjectUtils.nullSafeEquals(this.getElementTypeDescriptor(), other.getElementTypeDescriptor());
        }
        if (this.isMap()) {
            return ObjectUtils.nullSafeEquals(this.getMapKeyTypeDescriptor(), other.getMapKeyTypeDescriptor()) && ObjectUtils.nullSafeEquals(this.getMapValueTypeDescriptor(), other.getMapValueTypeDescriptor());
        }
        return true;
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public String toString() {
        Annotation[] anns;
        StringBuilder builder = new StringBuilder();
        Annotation[] annotationArray = anns = this.getAnnotations();
        int n = anns.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            builder.append("@").append(ann.annotationType().getName()).append(' ');
            ++n2;
        }
        builder.append(ClassUtils.getQualifiedName(this.getType()));
        if (this.isMap()) {
            builder.append("<").append(this.wildcard(this.getMapKeyTypeDescriptor()));
            builder.append(", ").append(this.wildcard(this.getMapValueTypeDescriptor())).append(">");
        } else if (this.isCollection()) {
            builder.append("<").append(this.wildcard(this.getElementTypeDescriptor())).append(">");
        }
        return builder.toString();
    }
}

