package mx.com.amx.mx.dda.crn.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import mx.com.amx.mx.dda.crn.dto.ContratoTituloDTO;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import mx.com.amx.mx.dda.crn.dto.TransaccionDTO;
import mx.com.amx.mx.dda.crn.dto.VisualizacionDTO;
import org.springframework.jdbc.core.BeanPropertyRowMapper;

@Component
@Qualifier("ddaexhibicionDAO")
public class DDACargaTransacVisualDAO implements IDDACargaDAO {

    private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
    private final String ARCHIVO_PROPIEDADES = "/general.properties";
    Properties env = new Properties();
    private JdbcTemplate jdbcTemplate;

    private String AMBIENTE;

    public DDACargaTransacVisualDAO() {
        super();
        try {
            env.load(this.getClass().getResourceAsStream(ARCHIVO_PROPIEDADES));
            AMBIENTE = env.getProperty("ambiente");

        } catch (Exception e) {
            LOG.error(">Constructor[" + this.getClass().getSimpleName() + "] Ocurrio un error : " + e.getMessage());
        }
    }

    @Override
    public List<TransaccionDTO> obtenerTransaccionesMes(String date) {
        List<TransaccionDTO> lobResultado = new ArrayList<>();
        StringBuilder sb = new StringBuilder();
        List<Object> qryParams = new ArrayList<>();

        try {
            //--Ejecucion
            sb.append("select CASE WHEN PAIS = 'ELSALVADOR' THEN 'EL SALVADOR' ");
            sb.append("WHEN PAIS = 'COSTARICA' THEN 'COSTA RICA' ");
            sb.append("WHEN PAIS = 'DOMINICANA' THEN 'DOMINICAN REP.' ELSE PAIS END PAIS ");
            sb.append(",ID_PROGRAM,TITULO,MEDIO_PAGO,ABONO,PRECIO,CANTIDAD,'HD' AS FORMATO,MES,FECHA_REGISTRO FROM DDA_CV_TRANSACCION  WHERE ");
            sb.append("to_date(?,'dd/mm/yyyy') =  to_date(to_char(MES,'dd/mm/yyyy'),'dd/mm/yyyy')");

            final String lstSQL = sb.toString();
            qryParams.add(date);

            lobResultado = (ArrayList<TransaccionDTO>) jdbcTemplate
                    .query(lstSQL, qryParams.toArray(), new BeanPropertyRowMapper<TransaccionDTO>(TransaccionDTO.class));

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerContratosSuscripcion]: " + e.getMessage());
        }

        return lobResultado;
    }

    public JdbcTemplate getJdbcTemplate() {
        return jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public boolean ejecutarSPAsociarTitTransCntVigentes(String pstIdCargaTrans) throws Exception {
        String lstIdCargaTransacciones = (pstIdCargaTrans != null && pstIdCargaTrans.trim().length() > 0) ? pstIdCargaTrans : "";
        LOG.debug("lstIdCargaTransacciones:" + lstIdCargaTransacciones);

        boolean resultado = false;
        StringBuffer sb = new StringBuffer();
        StringBuffer sbD = new StringBuffer();
        List<Object> qryParams = new ArrayList<Object>();
        int lnuRowsUpdate = 0;

        try {
            //--Debug
            sbD.append("call DDA_ASOC_TITTRANS_CNTVIG");
            LOG.debug(">Sql_D [ejecutarSPAsociarTitTransCntVigentes]:" + sbD.toString());

            //--Ejecucion
            sb.append("call DDA_ASOC_TITTRANS_CNTVIG(?)");

            final String lstSQL = sb.toString();
            qryParams.add(lstIdCargaTransacciones);

            lnuRowsUpdate = jdbcTemplate.update(lstSQL, qryParams.toArray());

            if (lnuRowsUpdate >= 0) {
                resultado = true;
            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::ejecutarSPAsociarTitTransCntVigentes]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }

        return resultado;
    }
    
    @Override
    public boolean ejecutarCalculoOverage(String pstIdCargaTrans) throws Exception {
        String lstIdCargaTransacciones = (pstIdCargaTrans != null && pstIdCargaTrans.trim().length() > 0) ? pstIdCargaTrans : "";
        LOG.debug("lstIdCargaTransacciones:" + lstIdCargaTransacciones);

        boolean resultado = false;
        StringBuffer sb = new StringBuffer();
        StringBuffer sbD = new StringBuffer();
        List<Object> qryParams = new ArrayList<Object>();
        int lnuRowsUpdate = 0;

        try {
            //--Debug
            sbD.append("call DDA_CNT_CALCULAR_OVERAGE");
            LOG.debug(">Sql_D [ejecutarSPAsociarTitTransCntVigentes]:" + sbD.toString());

            //--Ejecucion
            sb.append("call DDA_CNT_CALCULAR_OVERAGE(?)");

            final String lstSQL = sb.toString();
            qryParams.add(lstIdCargaTransacciones);

            lnuRowsUpdate = jdbcTemplate.update(lstSQL, qryParams.toArray());

            if (lnuRowsUpdate >= 0) {
                resultado = true;
            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::ejecutarSPAsociarTitTransCntVigentes]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }

        return resultado;
    }

    @Override
    public List<VisualizacionDTO> obtenerVisualizacionesMes(String date) {
        List<VisualizacionDTO> lobResultado = new ArrayList<>();
        StringBuilder sb = new StringBuilder();
        List<Object> qryParams = new ArrayList<>();

        try {
            //--Ejecucion
            sb.append("select ID_BV,TITULO,VISUALIZACIONES,to_char(MES,'dd/mm/yyyy') AS MES_F,FECHA_REGISTRO from DDA_CV_VISUALIZACION where ");
            sb.append("to_date(?,'dd/mm/yyyy') =  to_date(to_char(MES,'dd/mm/yyyy'),'dd/mm/yyyy')");

            final String lstSQL = sb.toString();
            qryParams.add(date);

            lobResultado = (ArrayList<VisualizacionDTO>) jdbcTemplate
                    .query(lstSQL, qryParams.toArray(), new BeanPropertyRowMapper<VisualizacionDTO>(VisualizacionDTO.class));

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerContratosSuscripcion]: " + e.getMessage());
        }

        return lobResultado;
    }

    @Override
    public String obtenerSiguienteIdCarga() {
        /* Se usa el objeto de ContratoTituloDTO para no tener que crear un DTO para el ID de Carga ya que solo se usaria para este proposito*/
        String resultado = "-1";
        List<ContratoTituloDTO> lobResultado = new ArrayList<>();
        StringBuffer sb = new StringBuffer();

        try {
            //--Ejecucion
            sb.append("select DDA_SQT_CARGA_TRANSACCION.NEXTVAL as ID_LISTA from dual ");
            final String lstSQL = sb.toString();

            lobResultado = (ArrayList<ContratoTituloDTO>) jdbcTemplate.query(lstSQL, new BeanPropertyRowMapper<>(ContratoTituloDTO.class));

            if (lobResultado != null && lobResultado.size() == 1) {
                resultado = (String) lobResultado.get(0).getID_LISTA();
            }
        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerSiguienteIdCarga]: " + e.getMessage());
        }

        return resultado;
    }

    @Override
    public boolean registrarCargaTransaccion(String idCarga, String date) {
        boolean resultado = false;
        List<Object> qryParams = new ArrayList<>();
        StringBuffer sb = new StringBuffer();

        try {
            //--Ejecucion
            sb.append("INSERT INTO DDA_T_CARGA_TRANSACCION (ID_CARGA_TRANS, MES, FECHA_VOBO, ESTATUS_CARGA) ");
            sb.append("VALUES (?, TO_DATE(?, 'DD/MM/YYYY'), null, null)");

            final String sql = sb.toString();
            qryParams.add(idCarga);
            qryParams.add(date);

            int lnumRowsInsertados = jdbcTemplate.update(sql, qryParams.toArray());

            if (lnumRowsInsertados > 0) {
                resultado = true;
            }
        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::registrarCalculoCostoTituloEscala]: " + e.getMessage());
        }

        return resultado;
    }

}
